/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.servlet.filters;

import com.liferay.portal.kernel.servlet.Header;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.util.servlet.filters.CacheResponseData;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;

public class CacheResponseUtil {
    public static void setHeaders(HttpServletResponse response, Map<String, Set<Header>> headers) {
        for (Map.Entry<String, Set<Header>> entry : headers.entrySet()) {
            String key = entry.getKey();
            boolean first = true;
            for (Header header : entry.getValue()) {
                if (first) {
                    header.setToResponse(key, response);
                    first = false;
                    continue;
                }
                header.addToResponse(key, response);
            }
        }
    }

    public static void write(HttpServletResponse response, CacheResponseData cacheResponseData) throws IOException {
        CacheResponseUtil.setHeaders(response, cacheResponseData.getHeaders());
        response.setContentType(cacheResponseData.getContentType());
        ServletResponseUtil.write((HttpServletResponse)response, (ByteBuffer)cacheResponseData.getByteBuffer());
    }
}

