/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.diff;

import com.liferay.portal.kernel.util.StringBundler;
import java.util.ArrayList;
import java.util.List;

public class DiffResult {
    public static final String SOURCE = "SOURCE";
    public static final String TARGET = "TARGET";
    private List<String> _changedLines;
    private int _lineNumber;

    public DiffResult(int linePos, List<String> changedLines) {
        this._lineNumber = linePos + 1;
        this._changedLines = changedLines;
    }

    public DiffResult(int linePos, String changedLine) {
        this._lineNumber = linePos + 1;
        this._changedLines = new ArrayList<String>();
        this._changedLines.add(changedLine);
    }

    public boolean equals(Object obj) {
        DiffResult diffResult = (DiffResult)obj;
        return diffResult.getLineNumber() == this._lineNumber && diffResult.getChangedLines().equals(this._changedLines);
    }

    public List<String> getChangedLines() {
        return this._changedLines;
    }

    public int getLineNumber() {
        return this._lineNumber;
    }

    public void setChangedLines(List<String> changedLines) {
        this._changedLines = changedLines;
    }

    public void setLineNumber(int lineNumber) {
        this._lineNumber = lineNumber;
    }

    public String toString() {
        StringBundler sb = new StringBundler(this._changedLines.size() * 2 + 3);
        sb.append("Line: ");
        sb.append(this._lineNumber);
        sb.append("\n");
        for (String changedLine : this._changedLines) {
            sb.append(changedLine);
            sb.append("\n");
        }
        if (!this._changedLines.isEmpty()) {
            sb.setIndex(sb.index() - 1);
        }
        return sb.toString();
    }
}

