/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.SecureRandomUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Random;

public class PwdGenerator {
    public static final String KEY1 = "0123456789";
    public static final String KEY2 = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String KEY3 = "abcdefghijklmnopqrstuvwxyz";
    private static final String[] KEYS = new String[]{"0123456789", "ABCDEFGHIJKLMNOPQRSTUVWXYZ", "abcdefghijklmnopqrstuvwxyz"};
    private static Log _log = LogFactoryUtil.getLog(PwdGenerator.class);

    public static String getPassword() {
        return PwdGenerator.getPassword(8, KEYS);
    }

    public static String getPassword(int length) {
        return PwdGenerator.getPassword(length, KEYS);
    }

    public static String getPassword(int length, String ... keys) {
        String key;
        if (length < keys.length) {
            length = keys.length;
        }
        StringBuilder sb = new StringBuilder(length);
        Random random = new Random(SecureRandomUtil.nextLong());
        int fullKeyLength = 0;
        String[] stringArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            key = stringArray[n2];
            fullKeyLength += key.length();
            ++n2;
        }
        stringArray = keys;
        n = keys.length;
        n2 = 0;
        while (n2 < n) {
            key = stringArray[n2];
            int count = key.length() * length / fullKeyLength;
            if (count == 0) {
                count = 1;
            }
            int i = 0;
            while (i < count) {
                sb.append(key.charAt(random.nextInt(key.length())));
                ++i;
            }
            ++n2;
        }
        int i = sb.length();
        while (i < length) {
            String key2 = keys[random.nextInt(keys.length)];
            sb.append(key2.charAt(random.nextInt(key2.length())));
            ++i;
        }
        i = length;
        while (i > 1) {
            int position = random.nextInt(i);
            if (position != i - 1) {
                char c = sb.charAt(position);
                sb.setCharAt(position, sb.charAt(i - 1));
                sb.setCharAt(i - 1, c);
            }
            --i;
        }
        return sb.toString();
    }

    public static String getPassword(String key, int length) {
        String password;
        int keysCount = 0;
        if (key.contains(KEY1)) {
            ++keysCount;
        }
        if (key.contains(KEY2)) {
            ++keysCount;
        }
        if (key.contains(KEY3)) {
            ++keysCount;
        }
        if (keysCount > length) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Length is too short");
            }
            length = keysCount;
        }
        do {
            password = PwdGenerator.getPassword(length, key);
        } while (key.contains(KEY1) && Validator.isNull((String)StringUtil.extractDigits((String)password)) || key.contains(KEY2) && password.equals(password.toLowerCase()) || key.contains(KEY3) && password.equals(password.toUpperCase()));
        return password;
    }

    public static String getPassword(String key, int length, boolean useAllKeys) {
        if (useAllKeys) {
            return PwdGenerator.getPassword(key, length);
        }
        return PwdGenerator.getPassword(length, key);
    }

    public static String getPinNumber() {
        return PwdGenerator.getPassword(4, KEY1);
    }
}

