/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.mail;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import javax.mail.Address;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.validator.EmailValidator;

public class InternetAddressUtil {
    public static boolean contains(InternetAddress[] internetAddresses, String emailAddress) {
        if (internetAddresses != null && Validator.isNotNull((String)emailAddress)) {
            int i = 0;
            while (i < internetAddresses.length) {
                if (emailAddress.equals(internetAddresses[i].getAddress())) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static boolean isValid(String emailAddress) {
        return EmailValidator.getInstance().isValid(emailAddress);
    }

    public static InternetAddress[] removeEntry(Address[] addresses, String emailAddress) {
        InternetAddress[] internetAddresses = (InternetAddress[])addresses;
        ArrayList<InternetAddress> list = new ArrayList<InternetAddress>();
        if (internetAddresses == null || Validator.isNull((String)emailAddress)) {
            return internetAddresses;
        }
        int i = 0;
        while (i < internetAddresses.length) {
            if (!emailAddress.equals(internetAddresses[i].getAddress())) {
                list.add(internetAddresses[i]);
            }
            ++i;
        }
        return list.toArray(new InternetAddress[list.size()]);
    }

    public static String toString(Address address) {
        InternetAddress internetAddress = (InternetAddress)address;
        if (internetAddress != null) {
            StringBundler sb = new StringBundler(5);
            String personal = internetAddress.getPersonal();
            String emailAddress = internetAddress.getAddress();
            if (Validator.isNotNull((String)personal)) {
                sb.append(personal);
                sb.append(" ");
                sb.append("<");
                sb.append(emailAddress);
                sb.append(">");
            } else {
                sb.append(emailAddress);
            }
            return sb.toString();
        }
        return "";
    }

    public static String toString(Address[] addresses) {
        if (addresses == null || addresses.length == 0) {
            return "";
        }
        StringBundler sb = new StringBundler(addresses.length * 2 - 1);
        int i = 0;
        while (i < addresses.length - 1) {
            sb.append(InternetAddressUtil.toString(addresses[i]));
            sb.append(",");
            ++i;
        }
        sb.append(InternetAddressUtil.toString(addresses[addresses.length - 1]));
        return sb.toString();
    }

    public static void validateAddress(Address address) throws AddressException {
        if (address == null) {
            throw new AddressException("Email address is null");
        }
        String addressString = address.toString();
        char[] cArray = addressString.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == '\n' || c == '\r') {
                StringBundler sb = new StringBundler(3);
                sb.append("Email address ");
                sb.append(addressString);
                sb.append(" is invalid because it contains line breaks");
                throw new AddressException(sb.toString());
            }
            ++n2;
        }
    }

    public static void validateAddresses(Address[] addresses) throws AddressException {
        if (addresses == null) {
            throw new AddressException();
        }
        Address[] addressArray = addresses;
        int n = addresses.length;
        int n2 = 0;
        while (n2 < n) {
            Address internetAddress = addressArray[n2];
            InternetAddressUtil.validateAddress(internetAddress);
            ++n2;
        }
    }
}

