/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.diff;

import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.util.diff.DiffResult;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.incava.util.diff.Diff;
import org.incava.util.diff.Difference;

public class DiffUtil {
    public static final String CLOSE_DEL = "</del>";
    public static final String CLOSE_INS = "</ins>";
    public static final String CONTEXT_LINE = "#context#line#";
    public static final String OPEN_DEL = "<del>";
    public static final String OPEN_INS = "<ins>";

    public static List<DiffResult>[] diff(Reader source, Reader target) {
        int margin = 2;
        return DiffUtil.diff(source, target, OPEN_INS, CLOSE_INS, OPEN_DEL, CLOSE_DEL, margin);
    }

    public static List<DiffResult>[] diff(Reader source, Reader target, String addedMarkerStart, String addedMarkerEnd, String deletedMarkerStart, String deletedMarkerEnd, int margin) {
        ArrayList<DiffResult> sourceResults = new ArrayList<DiffResult>();
        ArrayList<DiffResult> targetResults = new ArrayList<DiffResult>();
        List[] results = new List[]{sourceResults, targetResults};
        List sourceStringList = FileUtil.toList((Reader)source);
        List targetStringList = FileUtil.toList((Reader)target);
        Diff diff = new Diff((Collection)sourceStringList, (Collection)targetStringList);
        List differences = diff.diff();
        for (Difference difference : differences) {
            DiffResult diffResult;
            List<String> changedLines;
            if (difference.getAddedEnd() == -1) {
                DiffUtil._highlightLines(sourceStringList, deletedMarkerStart, deletedMarkerEnd, difference.getDeletedStart(), difference.getDeletedEnd());
                margin = DiffUtil._calculateMargin(sourceResults, targetResults, difference.getDeletedStart(), difference.getAddedStart(), margin);
                changedLines = DiffUtil._addMargins(sourceResults, sourceStringList, difference.getDeletedStart(), margin);
                DiffUtil._addResults(sourceResults, sourceStringList, changedLines, difference.getDeletedStart(), difference.getDeletedEnd());
                changedLines = DiffUtil._addMargins(targetResults, targetStringList, difference.getAddedStart(), margin);
                int deletedLines = difference.getDeletedEnd() + 1 - difference.getDeletedStart();
                int i = 0;
                while (i < deletedLines) {
                    changedLines.add(CONTEXT_LINE);
                    ++i;
                }
                diffResult = new DiffResult(difference.getDeletedStart(), changedLines);
                targetResults.add(diffResult);
                continue;
            }
            if (difference.getDeletedEnd() == -1) {
                DiffUtil._highlightLines(targetStringList, addedMarkerStart, addedMarkerEnd, difference.getAddedStart(), difference.getAddedEnd());
                margin = DiffUtil._calculateMargin(sourceResults, targetResults, difference.getDeletedStart(), difference.getAddedStart(), margin);
                changedLines = DiffUtil._addMargins(sourceResults, sourceStringList, difference.getDeletedStart(), margin);
                int addedLines = difference.getAddedEnd() + 1 - difference.getAddedStart();
                int i = 0;
                while (i < addedLines) {
                    changedLines.add(CONTEXT_LINE);
                    ++i;
                }
                diffResult = new DiffResult(difference.getAddedStart(), changedLines);
                sourceResults.add(diffResult);
                changedLines = DiffUtil._addMargins(targetResults, targetStringList, difference.getAddedStart(), margin);
                DiffUtil._addResults(targetResults, targetStringList, changedLines, difference.getAddedStart(), difference.getAddedEnd());
                continue;
            }
            DiffUtil._checkCharDiffs(sourceResults, targetResults, sourceStringList, targetStringList, addedMarkerStart, addedMarkerEnd, deletedMarkerStart, deletedMarkerEnd, difference, margin);
        }
        return results;
    }

    private static List<String> _addMargins(List<DiffResult> results, List<String> stringList, int startPos, int margin) {
        ArrayList<String> changedLines = new ArrayList<String>();
        if (margin == 0 || startPos == 0) {
            return changedLines;
        }
        int i = startPos - margin;
        while (i < 0) {
            changedLines.add(CONTEXT_LINE);
            ++i;
        }
        while (i < startPos) {
            if (i < stringList.size()) {
                changedLines.add(stringList.get(i));
            }
            ++i;
        }
        return changedLines;
    }

    private static void _addResults(List<DiffResult> results, List<String> stringList, List<String> changedLines, int start, int end) {
        changedLines.addAll(stringList.subList(start, end + 1));
        DiffResult diffResult = new DiffResult(start, changedLines);
        results.add(diffResult);
    }

    private static int _calculateMargin(List<DiffResult> sourceResults, List<DiffResult> targetResults, int sourceBeginPos, int targetBeginPos, int margin) {
        int targetMargin;
        int sourceMargin = DiffUtil._checkOverlapping(sourceResults, sourceBeginPos, margin);
        if (sourceMargin < (targetMargin = DiffUtil._checkOverlapping(targetResults, targetBeginPos, margin))) {
            return sourceMargin;
        }
        return targetMargin;
    }

    /*
     * Unable to fully structure code
     */
    private static void _checkCharDiffs(List<DiffResult> sourceResults, List<DiffResult> targetResults, List<String> sourceStringList, List<String> targetStringList, String addedMarkerStart, String addedMarkerEnd, String deletedMarkerStart, String deletedMarkerEnd, Difference difference, int margin) {
        aligned = false;
        i = difference.getDeletedStart();
        j = difference.getAddedStart();
        ** GOTO lbl26
        {
            block5: {
                if (!DiffUtil._lineDiff(sourceResults, targetResults, sourceStringList, targetStringList, addedMarkerStart, addedMarkerEnd, deletedMarkerStart, deletedMarkerEnd, i, j, false)) break block5;
                aligned = true;
                ** GOTO lbl18
            }
            DiffUtil._highlightLines(targetStringList, addedMarkerStart, addedMarkerEnd, j, j);
            targetResult = new DiffResult(j, targetStringList.subList(j, j + 1));
            targetResults.add(targetResult);
            sourceResults.add(new DiffResult(j, "#context#line#"));
            ++j;
            do {
                if (j <= difference.getAddedEnd()) continue block0;
lbl18:
                // 2 sources

                if (aligned) break block0;
                DiffUtil._highlightLines(sourceStringList, deletedMarkerStart, deletedMarkerEnd, i, i);
                sourceResult = new DiffResult(i, sourceStringList.subList(i, i + 1));
                sourceResults.add(sourceResult);
                targetResults.add(new DiffResult(i, "#context#line#"));
                ++i;
lbl26:
                // 2 sources

            } while (i <= difference.getDeletedEnd());
        }
        ++i;
        ++j;
        while (i <= difference.getDeletedEnd() && j <= difference.getAddedEnd()) {
            DiffUtil._lineDiff(sourceResults, targetResults, sourceStringList, targetStringList, addedMarkerStart, addedMarkerEnd, deletedMarkerStart, deletedMarkerEnd, i, j, true);
            ++i;
            ++j;
        }
        while (i <= difference.getDeletedEnd()) {
            DiffUtil._highlightLines(sourceStringList, deletedMarkerStart, deletedMarkerEnd, i, i);
            sourceResult = new DiffResult(i, sourceStringList.subList(i, i + 1));
            sourceResults.add(sourceResult);
            targetResults.add(new DiffResult(i, "#context#line#"));
            ++i;
        }
        while (j <= difference.getAddedEnd()) {
            DiffUtil._highlightLines(targetStringList, addedMarkerStart, addedMarkerEnd, j, j);
            targetResult = new DiffResult(j, targetStringList.subList(j, j + 1));
            targetResults.add(targetResult);
            sourceResults.add(new DiffResult(j, "#context#line#"));
            ++j;
        }
    }

    private static int _checkOverlapping(List<DiffResult> results, int startPos, int margin) {
        if (results.size() == 0 || startPos - margin < 0) {
            return margin;
        }
        DiffResult lastDiff = results.get(results.size() - 1);
        if (lastDiff.getChangedLines().size() == 0) {
            return margin;
        }
        int lastChangedLine = lastDiff.getLineNumber() - 1 + lastDiff.getChangedLines().size();
        int currentChangedLine = startPos - margin;
        if (lastDiff.getChangedLines().size() == 1 && lastDiff.getChangedLines().get(0).equals(CONTEXT_LINE)) {
            ++currentChangedLine;
        }
        if (currentChangedLine < lastChangedLine) {
            return margin + currentChangedLine - lastChangedLine;
        }
        return margin;
    }

    private static void _highlightChars(List<String> stringList, String markerStart, String markerEnd, int startPos, int endPos) {
        String start = String.valueOf(markerStart) + stringList.get(startPos);
        stringList.set(startPos, start);
        String end = String.valueOf(stringList.get(endPos)) + markerEnd;
        stringList.set(endPos, end);
    }

    private static void _highlightLines(List<String> stringList, String markerStart, String markerEnd, int startPos, int endPos) {
        int i = startPos;
        while (i <= endPos) {
            stringList.set(i, String.valueOf(markerStart) + stringList.get(i) + markerEnd);
            ++i;
        }
    }

    private static boolean _lineDiff(List<DiffResult> sourceResults, List<DiffResult> targetResults, List<String> sourceStringList, List<String> targetStringList, String addedMarkerStart, String addedMarkerEnd, String deletedMarkerStart, String deletedMarkerEnd, int sourceChangedLine, int targetChangedLine, boolean aligned) {
        DiffResult sourceResult;
        String source = sourceStringList.get(sourceChangedLine);
        String target = targetStringList.get(targetChangedLine);
        List<String> sourceList = DiffUtil._toList(source);
        List<String> targetList = DiffUtil._toList(target);
        Diff diff = new Diff(sourceList, targetList);
        List differences = diff.diff();
        Iterator itr = differences.iterator();
        int deletedChars = 0;
        int addedChars = 0;
        while (itr.hasNext() && !aligned) {
            Difference difference = (Difference)itr.next();
            if (difference.getDeletedEnd() != -1) {
                deletedChars += difference.getDeletedEnd() - difference.getDeletedStart() + 1;
            }
            if (difference.getAddedEnd() == -1) continue;
            addedChars += difference.getAddedEnd() - difference.getAddedStart() + 1;
        }
        if (deletedChars > sourceList.size() / 2 || addedChars > sourceList.size() / 2) {
            return false;
        }
        itr = differences.iterator();
        boolean sourceChanged = false;
        boolean targetChanged = false;
        while (itr.hasNext()) {
            Difference difference = (Difference)itr.next();
            if (difference.getAddedEnd() == -1) {
                DiffUtil._highlightChars(sourceList, deletedMarkerStart, deletedMarkerEnd, difference.getDeletedStart(), difference.getDeletedEnd());
                sourceChanged = true;
                continue;
            }
            if (difference.getDeletedEnd() == -1) {
                DiffUtil._highlightChars(targetList, addedMarkerStart, addedMarkerEnd, difference.getAddedStart(), difference.getAddedEnd());
                targetChanged = true;
                continue;
            }
            DiffUtil._highlightChars(sourceList, deletedMarkerStart, deletedMarkerEnd, difference.getDeletedStart(), difference.getDeletedEnd());
            sourceChanged = true;
            DiffUtil._highlightChars(targetList, addedMarkerStart, addedMarkerEnd, difference.getAddedStart(), difference.getAddedEnd());
            targetChanged = true;
        }
        if (sourceChanged) {
            sourceResult = new DiffResult(sourceChangedLine, DiffUtil._toString(sourceList));
            sourceResults.add(sourceResult);
            if (!targetChanged) {
                DiffResult targetResult = new DiffResult(targetChangedLine, target);
                targetResults.add(targetResult);
            }
        }
        if (targetChanged) {
            if (!sourceChanged) {
                sourceResult = new DiffResult(sourceChangedLine, source);
                sourceResults.add(sourceResult);
            }
            DiffResult targetResult = new DiffResult(targetChangedLine, DiffUtil._toString(targetList));
            targetResults.add(targetResult);
        }
        return true;
    }

    private static List<String> _toList(String line) {
        String[] stringArray = line.split("");
        ArrayList<String> result = new ArrayList<String>();
        int i = 1;
        while (i < stringArray.length) {
            result.add(stringArray[i]);
            ++i;
        }
        return result;
    }

    private static String _toString(List<String> line) {
        if (line.isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler(line.size());
        Iterator<String> itr = line.iterator();
        while (itr.hasNext()) {
            sb.append(itr.next());
        }
        return sb.toString();
    }
}

