/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.transport;

import com.liferay.util.transport.MulticastDatagramHandler;
import com.liferay.util.transport.MulticastTransport;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MulticastClientTool {
    public static void main(String[] args) {
        try {
            new MulticastClientTool(args);
        }
        catch (Exception e) {
            e.printStackTrace();
            StringBuilder sb = new StringBuilder(3);
            sb.append("Usage: java -classpath util-java.jar ");
            sb.append(MulticastClientTool.class.getName());
            sb.append("[-g] [-s] -h [multicastAddress] -p [port]");
            System.err.println(sb.toString());
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MulticastClientTool(String[] args) throws Exception {
        Map<String, Object> argsMap = this._getArgsMap(args);
        Integer port = (Integer)argsMap.get("port");
        String host = (String)argsMap.get("host");
        Boolean gzipData = (Boolean)argsMap.get("gzip");
        Boolean shortData = (Boolean)argsMap.get("short");
        MulticastDatagramHandler datagramHandler = new MulticastDatagramHandler(gzipData, shortData);
        MulticastTransport multicastTransport = new MulticastTransport(datagramHandler, host, port);
        if (shortData.booleanValue()) {
            System.out.println("Truncating to 96 bytes.");
        }
        System.out.println("Started up and waiting...");
        multicastTransport.connect();
        MulticastTransport multicastTransport2 = multicastTransport;
        synchronized (multicastTransport2) {
            multicastTransport.wait();
        }
    }

    private Map<String, Object> _getArgsMap(String[] args) throws Exception {
        HashMap<String, Object> argsMap = new HashMap<String, Object>();
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-g")) {
                argsMap.put("gzip", Boolean.TRUE);
            } else if (args[i].equals("-s")) {
                argsMap.put("short", Boolean.TRUE);
            } else if (args[i].equals("-h")) {
                argsMap.put("host", args[i + 1]);
                ++i;
            } else if (args[i].equals("-p")) {
                argsMap.put("port", new Integer(args[i + 1]));
                ++i;
            }
            ++i;
        }
        if (!argsMap.containsKey("gzip")) {
            argsMap.put("gzip", Boolean.FALSE);
        }
        if (!argsMap.containsKey("short")) {
            argsMap.put("short", Boolean.FALSE);
        }
        return argsMap;
    }
}

