/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.servlet.filters;

import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicFilterConfig
implements FilterConfig {
    private String _filterName;
    private Map<String, String> _parameters = new LinkedHashMap<String, String>();
    private ServletContext _servletContext;

    public DynamicFilterConfig(FilterConfig filterConfig) {
        Enumeration enu = filterConfig.getInitParameterNames();
        while (enu.hasMoreElements()) {
            String name = (String)enu.nextElement();
            this.addInitParameter(name, filterConfig.getInitParameter(name));
        }
    }

    public DynamicFilterConfig(String filterName, ServletContext servletContext) {
        this._filterName = filterName;
        this._servletContext = servletContext;
    }

    public void addInitParameter(String name, String value) {
        this._parameters.put(name, value);
    }

    public String getFilterName() {
        return this._filterName;
    }

    public String getInitParameter(String name) {
        return this._parameters.get(name);
    }

    public Enumeration<String> getInitParameterNames() {
        return Collections.enumeration(this._parameters.keySet());
    }

    public ServletContext getServletContext() {
        return this._servletContext;
    }
}

