/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.ant;

import com.liferay.portal.kernel.util.Validator;
import com.liferay.util.ant.AntUtil;
import java.io.File;
import java.util.Map;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.FilterSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyTask {
    public static void copyDirectory(File source, File destination) {
        CopyTask.copyDirectory(source, destination, null, null);
    }

    public static void copyDirectory(File source, File destination, String includes, String excludes) {
        CopyTask.copyDirectory(source, destination, includes, excludes, false, true);
    }

    public static void copyDirectory(File source, File destination, String includes, String excludes, boolean overwrite, boolean preserveLastModified) {
        Copy copy = new Copy();
        FileSet fileSet = new FileSet();
        fileSet.setDir(source);
        if (Validator.isNotNull((String)includes)) {
            fileSet.setIncludes(includes);
        }
        if (Validator.isNotNull((String)excludes)) {
            fileSet.setExcludes(excludes);
        }
        copy.setProject(AntUtil.getProject());
        copy.addFileset(fileSet);
        copy.setTodir(destination);
        copy.setOverwrite(overwrite);
        copy.setPreserveLastModified(preserveLastModified);
        copy.execute();
    }

    public static void copyDirectory(String source, String destination) {
        CopyTask.copyDirectory(source, destination, null, null);
    }

    public static void copyDirectory(String source, String destination, String includes, String excludes) {
        CopyTask.copyDirectory(new File(source), new File(destination), includes, excludes);
    }

    public static void copyDirectory(String source, String destination, String includes, String excludes, boolean overwrite, boolean preserveLastModified) {
        CopyTask.copyDirectory(new File(source), new File(destination), includes, excludes, overwrite, preserveLastModified);
    }

    public static void copyFile(File sourceFile, File destinationDir, boolean overwrite, boolean preserveLastModified) {
        CopyTask.copyFile(sourceFile, destinationDir, null, overwrite, preserveLastModified);
    }

    public static void copyFile(File sourceFile, File destinationDir, Map<String, String> filterMap, boolean overwrite, boolean preserveLastModified) {
        CopyTask.copyFile(sourceFile, destinationDir, null, filterMap, overwrite, preserveLastModified);
    }

    public static void copyFile(File sourceFile, File destinationDir, String destinationFileName, Map<String, String> filterMap, boolean overwrite, boolean preserveLastModified) {
        Copy copy = new Copy();
        copy.setFile(sourceFile);
        copy.setFiltering(true);
        copy.setOverwrite(overwrite);
        copy.setPreserveLastModified(preserveLastModified);
        copy.setProject(AntUtil.getProject());
        if (destinationFileName == null) {
            copy.setTodir(destinationDir);
        } else {
            copy.setTofile(new File(destinationDir, destinationFileName));
        }
        if (filterMap != null) {
            FilterSet filterSet = copy.createFilterSet();
            for (Map.Entry<String, String> entry : filterMap.entrySet()) {
                String token = entry.getKey();
                String replacement = entry.getValue();
                filterSet.addFilter(token, replacement);
            }
        }
        copy.execute();
    }
}

