/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util;

import com.liferay.ibm.icu.text.Transliterator;
import com.liferay.portal.kernel.util.StringUtil;

public class Normalizer {
    private static final String _NORMALIZED_TEXT = "l";
    private static final String _UNICODE_TEXT = "\u0142";
    private static Transliterator _transliterator = Transliterator.getInstance((String)"NFD; [:Nonspacing Mark:] Remove; NFC");

    public static String normalizeToAscii(String s) {
        if (!Normalizer._hasNonASCIICode(s)) {
            return s;
        }
        String normalizedText = _transliterator.transform(s);
        return StringUtil.replace((String)normalizedText, (String)_UNICODE_TEXT, (String)_NORMALIZED_TEXT);
    }

    private static boolean _hasNonASCIICode(String s) {
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) > '\u007f') {
                return true;
            }
            ++i;
        }
        return false;
    }
}

