/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util;

import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.util.StreamUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;

public class SerializableUtil {
    public static Object clone(Object object) {
        return SerializableUtil.deserialize(SerializableUtil.serialize(object));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object deserialize(byte[] bytes) {
        Object object;
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream((InputStream)new UnsyncByteArrayInputStream(bytes));
            object = objectInputStream.readObject();
        }
        catch (ClassNotFoundException cnfe) {
            try {
                throw new RuntimeException(cnfe);
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }
            catch (Throwable throwable) {
                StreamUtil.cleanUp(objectInputStream);
                throw throwable;
            }
        }
        StreamUtil.cleanUp((InputStream)objectInputStream);
        return object;
    }

    public static byte[] serialize(Object object) {
        ObjectOutputStream objectOutputStream = null;
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        try {
            try {
                objectOutputStream = new ObjectOutputStream((OutputStream)unsyncByteArrayOutputStream);
                objectOutputStream.writeObject(object);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        catch (Throwable throwable) {
            StreamUtil.cleanUp(objectOutputStream);
            throw throwable;
        }
        StreamUtil.cleanUp((OutputStream)objectOutputStream);
        return unsyncByteArrayOutputStream.toByteArray();
    }
}

