/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.xml;

import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class XMLFormatter {
    public static String fixProlog(String xml) {
        int pos;
        if (xml != null && (pos = xml.indexOf(60)) > 0) {
            xml = xml.substring(pos);
        }
        return xml;
    }

    public static String fromCompactSafe(String xml) {
        return StringUtil.replace((String)xml, (String)"[$NEW_LINE$]", (String)"\n");
    }

    public static String stripInvalidChars(String xml) {
        if (Validator.isNull((String)xml)) {
            return xml;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < xml.length(); ++i) {
            char c = xml.charAt(i);
            if (!(c == '\t' || c == '\n' || c == '\r' || c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd') && (c < '\u10000' || c > '\u10ffff')) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String toCompactSafe(String xml) {
        return StringUtil.replace((String)xml, (String[])new String[]{"\r\n", "\n", "\r"}, (String[])new String[]{"[$NEW_LINE$]", "[$NEW_LINE$]", "[$NEW_LINE$]"});
    }

    public static String toString(Branch branch) throws IOException {
        return XMLFormatter.toString(branch, "\t");
    }

    public static String toString(Branch branch, String indent) throws IOException {
        return XMLFormatter.toString(branch, "\t", false);
    }

    public static String toString(Branch branch, String indent, boolean expandEmptyElements) throws IOException {
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        OutputFormat outputFormat = OutputFormat.createPrettyPrint();
        outputFormat.setExpandEmptyElements(expandEmptyElements);
        outputFormat.setIndent(indent);
        outputFormat.setLineSeparator("\n");
        XMLWriter writer = new XMLWriter((OutputStream)unsyncByteArrayOutputStream, outputFormat);
        writer.write((Node)branch);
        String content = unsyncByteArrayOutputStream.toString("UTF-8");
        if (content.endsWith("\n\n")) {
            content = content.substring(0, content.length() - 2);
        }
        if (content.endsWith("\n")) {
            content = content.substring(0, content.length() - 1);
        }
        while (content.indexOf(" \n") != -1) {
            content = StringUtil.replace((String)content, (String)" \n", (String)"\n");
        }
        return content;
    }

    public static String toString(String xml) throws DocumentException, IOException {
        return XMLFormatter.toString(xml, "\t");
    }

    public static String toString(String xml, String indent) throws DocumentException, IOException {
        SAXReader reader = new SAXReader();
        Document doc = reader.read((Reader)new UnsyncStringReader(xml));
        return XMLFormatter.toString((Branch)doc, indent);
    }
}

