/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.util.Normalizer;
import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.SyndFeedOutput;
import java.util.List;
import org.jdom.IllegalDataException;

public class RSSUtil {
    public static final String RSS = "rss";
    public static final double[] RSS_VERSIONS = new double[]{0.9, 0.91, 0.93, 0.94, 1.0, 2.0};
    public static final String ATOM = "atom";
    public static final double[] ATOM_VERSIONS = new double[]{0.3, 1.0};
    public static final String DEFAULT_TYPE = "atom";
    public static final double DEFAULT_VERSION = 1.0;
    public static final String DEFAULT_ENTRY_TYPE = "html";
    public static final String DEFAULT_FEED_TYPE = RSSUtil.getFeedType("atom", 1.0);
    public static final String DISPLAY_STYLE_ABSTRACT = "abstract";
    public static final String DISPLAY_STYLE_FULL_CONTENT = "full-content";
    public static final String DISPLAY_STYLE_TITLE = "title";
    private static final String _REGEXP_STRIP = "[\\d\\w]";

    public static String export(SyndFeed feed) throws FeedException {
        feed.setEncoding("UTF-8");
        SyndFeedOutput output = new SyndFeedOutput();
        try {
            return output.outputString(feed);
        }
        catch (IllegalDataException ide) {
            RSSUtil._regexpStrip(feed);
            return output.outputString(feed);
        }
    }

    public static String getFeedType(String type, double version) {
        return type + "_" + version;
    }

    public static String getFormatType(String format) {
        String formatType = "atom";
        if (StringUtil.contains((String)format, (String)"atom")) {
            formatType = "atom";
        } else if (StringUtil.contains((String)format, (String)RSS)) {
            formatType = RSS;
        }
        return formatType;
    }

    public static double getFormatVersion(String format) {
        double formatVersion = 1.0;
        if (StringUtil.contains((String)format, (String)"10")) {
            formatVersion = 1.0;
        } else if (StringUtil.contains((String)format, (String)"20")) {
            formatVersion = 2.0;
        }
        return formatVersion;
    }

    private static void _regexpStrip(SyndFeed feed) {
        feed.setTitle(RSSUtil._regexpStrip(feed.getTitle()));
        feed.setDescription(RSSUtil._regexpStrip(feed.getDescription()));
        List entries = feed.getEntries();
        for (SyndEntry entry : entries) {
            entry.setTitle(RSSUtil._regexpStrip(entry.getTitle()));
            SyndContent content = entry.getDescription();
            content.setValue(RSSUtil._regexpStrip(content.getValue()));
        }
    }

    private static String _regexpStrip(String text) {
        text = Normalizer.normalizeToAscii(text);
        char[] array = text.toCharArray();
        for (int i = 0; i < array.length; ++i) {
            String s = String.valueOf(array[i]);
            if (s.matches(_REGEXP_STRIP)) continue;
            array[i] = 32;
        }
        return new String(array);
    }
}

