/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.plutonium.thymeleaf.portlet;

import jakarta.portlet.ClientDataRequest;
import jakarta.portlet.PortletRequest;
import jakarta.portlet.RenderRequest;
import jakarta.servlet.http.Cookie;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.thymeleaf.web.IWebRequest;

public class PortletIWebRequest
implements IWebRequest {
    private final PortletRequest portletRequest;

    public PortletIWebRequest(PortletRequest portletRequest) {
        this.portletRequest = portletRequest;
    }

    public String getMethod() {
        if (this.portletRequest instanceof RenderRequest) {
            return "GET";
        }
        if (this.portletRequest instanceof ClientDataRequest) {
            ClientDataRequest clientDataRequest = (ClientDataRequest)this.portletRequest;
            return clientDataRequest.getMethod();
        }
        throw new UnsupportedOperationException("Unsupported PortletRequest type for method retrieval");
    }

    public String getScheme() {
        return this.portletRequest.getScheme();
    }

    public String getServerName() {
        return this.portletRequest.getServerName();
    }

    public Integer getServerPort() {
        return this.portletRequest.getServerPort();
    }

    public String getApplicationPath() {
        return this.portletRequest.getContextPath();
    }

    public String getPathWithinApplication() {
        throw new UnsupportedOperationException();
    }

    public String getQueryString() {
        Map paramMap = this.portletRequest.getParameterMap();
        if (paramMap == null || paramMap.isEmpty()) {
            return null;
        }
        StringBuilder queryString = new StringBuilder();
        for (Map.Entry entry : paramMap.entrySet()) {
            if (queryString.length() > 0) {
                queryString.append("&");
            }
            String key = (String)entry.getKey();
            CharSequence[] values = (String[])entry.getValue();
            if (key == null || values == null) continue;
            queryString.append(key).append("=").append(String.join((CharSequence)",", values));
        }
        return queryString.toString();
    }

    public boolean containsHeader(String name) {
        return name != null && this.portletRequest.getProperty(name) != null;
    }

    public int getHeaderCount() {
        Enumeration headerNames = this.portletRequest.getPropertyNames();
        return headerNames != null ? Collections.list(headerNames).size() : 0;
    }

    public Set<String> getAllHeaderNames() {
        Enumeration headerNames = this.portletRequest.getPropertyNames();
        return headerNames != null ? new HashSet(Collections.list(headerNames)) : new HashSet();
    }

    public Map<String, String[]> getHeaderMap() {
        HashMap<String, String[]> headers = new HashMap<String, String[]>();
        Enumeration headerNames = this.portletRequest.getPropertyNames();
        if (headerNames != null) {
            while (headerNames.hasMoreElements()) {
                String name = (String)headerNames.nextElement();
                Enumeration values = this.portletRequest.getProperties(name);
                if (name == null || values == null) continue;
                headers.put(name, Collections.list(values).toArray(new String[0]));
            }
        }
        return headers;
    }

    public String[] getHeaderValues(String name) {
        if (name == null) {
            return new String[0];
        }
        Enumeration values = this.portletRequest.getProperties(name);
        return values != null ? Collections.list(values).toArray(new String[0]) : new String[]{};
    }

    public boolean containsParameter(String name) {
        return name != null && this.portletRequest.getParameter(name) != null;
    }

    public int getParameterCount() {
        Map paramMap = this.portletRequest.getParameterMap();
        return paramMap != null ? paramMap.size() : 0;
    }

    public Set<String> getAllParameterNames() {
        Map paramMap = this.portletRequest.getParameterMap();
        return paramMap != null ? paramMap.keySet() : new HashSet<String>();
    }

    public Map<String, String[]> getParameterMap() {
        Map paramMap = this.portletRequest.getParameterMap();
        return paramMap != null ? paramMap : new HashMap();
    }

    public String[] getParameterValues(String name) {
        return name != null ? this.portletRequest.getParameterValues(name) : new String[]{};
    }

    public boolean containsCookie(String name) {
        if (name == null) {
            return false;
        }
        Cookie[] cookies = this.portletRequest.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!name.equals(cookie.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public int getCookieCount() {
        Cookie[] cookies = this.portletRequest.getCookies();
        return cookies != null ? cookies.length : 0;
    }

    public Set<String> getAllCookieNames() {
        HashSet<String> cookieNames = new HashSet<String>();
        Cookie[] cookies = this.portletRequest.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (cookie.getName() == null) continue;
                cookieNames.add(cookie.getName());
            }
        }
        return cookieNames;
    }

    public Map<String, String[]> getCookieMap() {
        HashMap<String, String[]> cookieMap = new HashMap<String, String[]>();
        Cookie[] cookies = this.portletRequest.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (cookie.getName() == null || cookie.getValue() == null) continue;
                cookieMap.put(cookie.getName(), new String[]{cookie.getValue()});
            }
        }
        return cookieMap;
    }

    public String[] getCookieValues(String name) {
        if (name == null) {
            return new String[0];
        }
        ArrayList<String> values = new ArrayList<String>();
        Cookie[] cookies = this.portletRequest.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!name.equals(cookie.getName()) || cookie.getValue() == null) continue;
                values.add(cookie.getValue());
            }
        }
        return values.toArray(new String[0]);
    }
}

