/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.plutonium.thymeleaf.portlet;

import jakarta.portlet.PortletContext;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.thymeleaf.web.IWebApplication;

public class PortletIWebApplication
implements IWebApplication {
    private final PortletContext portletContext;

    public PortletIWebApplication(PortletContext portletContext) {
        this.portletContext = portletContext;
    }

    public boolean containsAttribute(String name) {
        return this.portletContext.getAttribute(name) != null;
    }

    public int getAttributeCount() {
        Enumeration attributeNames = this.portletContext.getAttributeNames();
        int count = 0;
        while (attributeNames.hasMoreElements()) {
            attributeNames.nextElement();
            ++count;
        }
        return count;
    }

    public Set<String> getAllAttributeNames() {
        HashSet<String> attributeNamesSet = new HashSet<String>();
        Enumeration attributeNames = this.portletContext.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            attributeNamesSet.add((String)attributeNames.nextElement());
        }
        return attributeNamesSet;
    }

    public Map<String, Object> getAttributeMap() {
        HashMap<String, Object> attributeMap = new HashMap<String, Object>();
        Enumeration attributeNames = this.portletContext.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String name = (String)attributeNames.nextElement();
            attributeMap.put(name, this.portletContext.getAttribute(name));
        }
        return attributeMap;
    }

    public Object getAttributeValue(String name) {
        return this.portletContext.getAttribute(name);
    }

    public void setAttributeValue(String name, Object value) {
        this.portletContext.setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        this.portletContext.removeAttribute(name);
    }

    public boolean resourceExists(String path) {
        return this.portletContext.getResourceAsStream(path) != null;
    }

    public InputStream getResourceAsStream(String path) {
        return this.portletContext.getResourceAsStream(path);
    }
}

