/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.portal.resiliency.spi.model.impl;

import com.liferay.portal.resiliency.spi.model.SPIDefinition;
import com.liferay.portal.resiliency.spi.service.SPIDefinitionLocalServiceUtil;

/**
 * The extended model base implementation for the SPIDefinition service. Represents a row in the &quot;SPIDefinition&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link SPIDefinitionImpl}.
 * </p>
 *
 * @author Michael C. Han
 * @see SPIDefinitionImpl
 * @see SPIDefinition
 * @generated
 */
public abstract class SPIDefinitionBaseImpl
	extends SPIDefinitionModelImpl implements SPIDefinition {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a spi definition model instance should use the <code>SPIDefinition</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			SPIDefinitionLocalServiceUtil.addSPIDefinition(this);
		}
		else {
			SPIDefinitionLocalServiceUtil.updateSPIDefinition(this);
		}
	}

}