/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.powwow.service;

import com.liferay.portal.kernel.service.ServiceWrapper;

/**
 * Provides a wrapper for {@link PowwowMeetingService}.
 *
 * @author Shinn Lok
 * @see PowwowMeetingService
 * @generated
 */
public class PowwowMeetingServiceWrapper
	implements PowwowMeetingService, ServiceWrapper<PowwowMeetingService> {

	public PowwowMeetingServiceWrapper(
		PowwowMeetingService powwowMeetingService) {

		_powwowMeetingService = powwowMeetingService;
	}

	@Override
	public com.liferay.powwow.model.PowwowMeeting addPowwowMeeting(
			long groupId, String portletId, long powwowServerId, String name,
			String description, String providerType,
			java.util.Map<String, java.io.Serializable> providerTypeMetadataMap,
			String languageId, long calendarBookingId, int status,
			java.util.List<com.liferay.powwow.model.PowwowParticipant>
				powwowParticipants,
			com.liferay.portal.kernel.service.ServiceContext serviceContext)
		throws com.liferay.portal.kernel.exception.PortalException {

		return _powwowMeetingService.addPowwowMeeting(
			groupId, portletId, powwowServerId, name, description, providerType,
			providerTypeMetadataMap, languageId, calendarBookingId, status,
			powwowParticipants, serviceContext);
	}

	@Override
	public com.liferay.powwow.model.PowwowMeeting deletePowwowMeeting(
			long powwowMeetingId)
		throws com.liferay.portal.kernel.exception.PortalException {

		return _powwowMeetingService.deletePowwowMeeting(powwowMeetingId);
	}

	/**
	 * Returns the OSGi service identifier.
	 *
	 * @return the OSGi service identifier
	 */
	@Override
	public String getOSGiServiceIdentifier() {
		return _powwowMeetingService.getOSGiServiceIdentifier();
	}

	@Override
	public com.liferay.powwow.model.PowwowMeeting getPowwowMeeting(
			long powwowMeetingId)
		throws com.liferay.portal.kernel.exception.PortalException {

		return _powwowMeetingService.getPowwowMeeting(powwowMeetingId);
	}

	@Override
	public java.util.List<com.liferay.powwow.model.PowwowMeeting>
		getPowwowMeetings(
			long groupId, int start, int end,
			com.liferay.portal.kernel.util.OrderByComparator
				<com.liferay.powwow.model.PowwowMeeting> orderByComparator) {

		return _powwowMeetingService.getPowwowMeetings(
			groupId, start, end, orderByComparator);
	}

	@Override
	public int getPowwowMeetingsCount(long groupId) {
		return _powwowMeetingService.getPowwowMeetingsCount(groupId);
	}

	@Override
	public com.liferay.powwow.model.PowwowMeeting updatePowwowMeeting(
			long powwowMeetingId, long powwowServerId, String name,
			String description, String providerType,
			java.util.Map<String, java.io.Serializable> providerTypeMetadataMap,
			String languageId, long calendarBookingId, int status,
			java.util.List<com.liferay.powwow.model.PowwowParticipant>
				powwowParticipants,
			com.liferay.portal.kernel.service.ServiceContext serviceContext)
		throws com.liferay.portal.kernel.exception.PortalException {

		return _powwowMeetingService.updatePowwowMeeting(
			powwowMeetingId, powwowServerId, name, description, providerType,
			providerTypeMetadataMap, languageId, calendarBookingId, status,
			powwowParticipants, serviceContext);
	}

	@Override
	public PowwowMeetingService getWrappedService() {
		return _powwowMeetingService;
	}

	@Override
	public void setWrappedService(PowwowMeetingService powwowMeetingService) {
		_powwowMeetingService = powwowMeetingService;
	}

	private PowwowMeetingService _powwowMeetingService;

}