/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.opensocial.model;

import com.liferay.portal.kernel.bean.AutoEscape;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ShardedModel;

import java.util.Date;

import org.osgi.annotation.versioning.ProviderType;

/**
 * The base model interface for the OAuthConsumer service. Represents a row in the &quot;OpenSocial_OAuthConsumer&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation <code>com.liferay.opensocial.model.impl.OAuthConsumerModelImpl</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in <code>com.liferay.opensocial.model.impl.OAuthConsumerImpl</code>.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see OAuthConsumer
 * @generated
 */
@ProviderType
public interface OAuthConsumerModel
	extends BaseModel<OAuthConsumer>, ShardedModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a o auth consumer model instance should use the {@link OAuthConsumer} interface instead.
	 */

	/**
	 * Returns the primary key of this o auth consumer.
	 *
	 * @return the primary key of this o auth consumer
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this o auth consumer.
	 *
	 * @param primaryKey the primary key of this o auth consumer
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the o auth consumer ID of this o auth consumer.
	 *
	 * @return the o auth consumer ID of this o auth consumer
	 */
	public long getOAuthConsumerId();

	/**
	 * Sets the o auth consumer ID of this o auth consumer.
	 *
	 * @param oAuthConsumerId the o auth consumer ID of this o auth consumer
	 */
	public void setOAuthConsumerId(long oAuthConsumerId);

	/**
	 * Returns the company ID of this o auth consumer.
	 *
	 * @return the company ID of this o auth consumer
	 */
	@Override
	public long getCompanyId();

	/**
	 * Sets the company ID of this o auth consumer.
	 *
	 * @param companyId the company ID of this o auth consumer
	 */
	@Override
	public void setCompanyId(long companyId);

	/**
	 * Returns the create date of this o auth consumer.
	 *
	 * @return the create date of this o auth consumer
	 */
	public Date getCreateDate();

	/**
	 * Sets the create date of this o auth consumer.
	 *
	 * @param createDate the create date of this o auth consumer
	 */
	public void setCreateDate(Date createDate);

	/**
	 * Returns the modified date of this o auth consumer.
	 *
	 * @return the modified date of this o auth consumer
	 */
	public Date getModifiedDate();

	/**
	 * Sets the modified date of this o auth consumer.
	 *
	 * @param modifiedDate the modified date of this o auth consumer
	 */
	public void setModifiedDate(Date modifiedDate);

	/**
	 * Returns the gadget key of this o auth consumer.
	 *
	 * @return the gadget key of this o auth consumer
	 */
	@AutoEscape
	public String getGadgetKey();

	/**
	 * Sets the gadget key of this o auth consumer.
	 *
	 * @param gadgetKey the gadget key of this o auth consumer
	 */
	public void setGadgetKey(String gadgetKey);

	/**
	 * Returns the service name of this o auth consumer.
	 *
	 * @return the service name of this o auth consumer
	 */
	@AutoEscape
	public String getServiceName();

	/**
	 * Sets the service name of this o auth consumer.
	 *
	 * @param serviceName the service name of this o auth consumer
	 */
	public void setServiceName(String serviceName);

	/**
	 * Returns the consumer key of this o auth consumer.
	 *
	 * @return the consumer key of this o auth consumer
	 */
	@AutoEscape
	public String getConsumerKey();

	/**
	 * Sets the consumer key of this o auth consumer.
	 *
	 * @param consumerKey the consumer key of this o auth consumer
	 */
	public void setConsumerKey(String consumerKey);

	/**
	 * Returns the consumer secret of this o auth consumer.
	 *
	 * @return the consumer secret of this o auth consumer
	 */
	@AutoEscape
	public String getConsumerSecret();

	/**
	 * Sets the consumer secret of this o auth consumer.
	 *
	 * @param consumerSecret the consumer secret of this o auth consumer
	 */
	public void setConsumerSecret(String consumerSecret);

	/**
	 * Returns the key type of this o auth consumer.
	 *
	 * @return the key type of this o auth consumer
	 */
	@AutoEscape
	public String getKeyType();

	/**
	 * Sets the key type of this o auth consumer.
	 *
	 * @param keyType the key type of this o auth consumer
	 */
	public void setKeyType(String keyType);

}