/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.opensocial.model.impl;

import com.liferay.opensocial.model.Gadget;
import com.liferay.opensocial.service.GadgetLocalServiceUtil;

/**
 * The extended model base implementation for the Gadget service. Represents a row in the &quot;OpenSocial_Gadget&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link GadgetImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see GadgetImpl
 * @see Gadget
 * @generated
 */
public abstract class GadgetBaseImpl extends GadgetModelImpl implements Gadget {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a gadget model instance should use the <code>Gadget</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			GadgetLocalServiceUtil.addGadget(this);
		}
		else {
			GadgetLocalServiceUtil.updateGadget(this);
		}
	}

}