/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.opensocial.model.impl;

import com.liferay.opensocial.model.OAuthConsumer;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.util.HashUtil;
import com.liferay.portal.kernel.util.StringBundler;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

import java.util.Date;

/**
 * The cache model class for representing OAuthConsumer in entity cache.
 *
 * @author Brian Wing Shun Chan
 * @generated
 */
public class OAuthConsumerCacheModel
	implements CacheModel<OAuthConsumer>, Externalizable {

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof OAuthConsumerCacheModel)) {
			return false;
		}

		OAuthConsumerCacheModel oAuthConsumerCacheModel =
			(OAuthConsumerCacheModel)object;

		if (oAuthConsumerId == oAuthConsumerCacheModel.oAuthConsumerId) {
			return true;
		}

		return false;
	}

	@Override
	public int hashCode() {
		return HashUtil.hash(0, oAuthConsumerId);
	}

	@Override
	public String toString() {
		StringBundler sb = new StringBundler(19);

		sb.append("{oAuthConsumerId=");
		sb.append(oAuthConsumerId);
		sb.append(", companyId=");
		sb.append(companyId);
		sb.append(", createDate=");
		sb.append(createDate);
		sb.append(", modifiedDate=");
		sb.append(modifiedDate);
		sb.append(", gadgetKey=");
		sb.append(gadgetKey);
		sb.append(", serviceName=");
		sb.append(serviceName);
		sb.append(", consumerKey=");
		sb.append(consumerKey);
		sb.append(", consumerSecret=");
		sb.append(consumerSecret);
		sb.append(", keyType=");
		sb.append(keyType);
		sb.append("}");

		return sb.toString();
	}

	@Override
	public OAuthConsumer toEntityModel() {
		OAuthConsumerImpl oAuthConsumerImpl = new OAuthConsumerImpl();

		oAuthConsumerImpl.setOAuthConsumerId(oAuthConsumerId);
		oAuthConsumerImpl.setCompanyId(companyId);

		if (createDate == Long.MIN_VALUE) {
			oAuthConsumerImpl.setCreateDate(null);
		}
		else {
			oAuthConsumerImpl.setCreateDate(new Date(createDate));
		}

		if (modifiedDate == Long.MIN_VALUE) {
			oAuthConsumerImpl.setModifiedDate(null);
		}
		else {
			oAuthConsumerImpl.setModifiedDate(new Date(modifiedDate));
		}

		if (gadgetKey == null) {
			oAuthConsumerImpl.setGadgetKey("");
		}
		else {
			oAuthConsumerImpl.setGadgetKey(gadgetKey);
		}

		if (serviceName == null) {
			oAuthConsumerImpl.setServiceName("");
		}
		else {
			oAuthConsumerImpl.setServiceName(serviceName);
		}

		if (consumerKey == null) {
			oAuthConsumerImpl.setConsumerKey("");
		}
		else {
			oAuthConsumerImpl.setConsumerKey(consumerKey);
		}

		if (consumerSecret == null) {
			oAuthConsumerImpl.setConsumerSecret("");
		}
		else {
			oAuthConsumerImpl.setConsumerSecret(consumerSecret);
		}

		if (keyType == null) {
			oAuthConsumerImpl.setKeyType("");
		}
		else {
			oAuthConsumerImpl.setKeyType(keyType);
		}

		oAuthConsumerImpl.resetOriginalValues();

		return oAuthConsumerImpl;
	}

	@Override
	public void readExternal(ObjectInput objectInput)
		throws ClassNotFoundException, IOException {

		oAuthConsumerId = objectInput.readLong();

		companyId = objectInput.readLong();
		createDate = objectInput.readLong();
		modifiedDate = objectInput.readLong();
		gadgetKey = objectInput.readUTF();
		serviceName = objectInput.readUTF();
		consumerKey = objectInput.readUTF();
		consumerSecret = (String)objectInput.readObject();
		keyType = objectInput.readUTF();
	}

	@Override
	public void writeExternal(ObjectOutput objectOutput) throws IOException {
		objectOutput.writeLong(oAuthConsumerId);

		objectOutput.writeLong(companyId);
		objectOutput.writeLong(createDate);
		objectOutput.writeLong(modifiedDate);

		if (gadgetKey == null) {
			objectOutput.writeUTF("");
		}
		else {
			objectOutput.writeUTF(gadgetKey);
		}

		if (serviceName == null) {
			objectOutput.writeUTF("");
		}
		else {
			objectOutput.writeUTF(serviceName);
		}

		if (consumerKey == null) {
			objectOutput.writeUTF("");
		}
		else {
			objectOutput.writeUTF(consumerKey);
		}

		if (consumerSecret == null) {
			objectOutput.writeObject("");
		}
		else {
			objectOutput.writeObject(consumerSecret);
		}

		if (keyType == null) {
			objectOutput.writeUTF("");
		}
		else {
			objectOutput.writeUTF(keyType);
		}
	}

	public long oAuthConsumerId;
	public long companyId;
	public long createDate;
	public long modifiedDate;
	public String gadgetKey;
	public String serviceName;
	public String consumerKey;
	public String consumerSecret;
	public String keyType;

}