/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.opensocial.model.impl;

import com.liferay.opensocial.model.OAuthConsumer;
import com.liferay.opensocial.service.OAuthConsumerLocalServiceUtil;

/**
 * The extended model base implementation for the OAuthConsumer service. Represents a row in the &quot;OpenSocial_OAuthConsumer&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link OAuthConsumerImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see OAuthConsumerImpl
 * @see OAuthConsumer
 * @generated
 */
public abstract class OAuthConsumerBaseImpl
	extends OAuthConsumerModelImpl implements OAuthConsumer {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a o auth consumer model instance should use the <code>OAuthConsumer</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			OAuthConsumerLocalServiceUtil.addOAuthConsumer(this);
		}
		else {
			OAuthConsumerLocalServiceUtil.updateOAuthConsumer(this);
		}
	}

}