define("liferay-1975-london-theme@1.0.56/js/music_player.es", ['exports', 'metal-dom/src/all/dom', 'metal-state/src/State', 'metal/src/metal'], function (exports, _dom, _State2, _metal) {
	'use strict';

	Object.defineProperty(exports, "__esModule", {
		value: true
	});

	var _dom2 = _interopRequireDefault(_dom);

	var _State3 = _interopRequireDefault(_State2);

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : {
			default: obj
		};
	}

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];
				descriptor.enumerable = descriptor.enumerable || false;
				descriptor.configurable = true;
				if ("value" in descriptor) descriptor.writable = true;
				Object.defineProperty(target, descriptor.key, descriptor);
			}
		}

		return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);
			if (staticProps) defineProperties(Constructor, staticProps);
			return Constructor;
		};
	}();

	function _possibleConstructorReturn(self, call) {
		if (!self) {
			throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
		}

		return call && (typeof call === "object" || typeof call === "function") ? call : self;
	}

	var _get = function get(object, property, receiver) {
		if (object === null) object = Function.prototype;
		var desc = Object.getOwnPropertyDescriptor(object, property);

		if (desc === undefined) {
			var parent = Object.getPrototypeOf(object);

			if (parent === null) {
				return undefined;
			} else {
				return get(parent, property, receiver);
			}
		} else if ("value" in desc) {
			return desc.value;
		} else {
			var getter = desc.get;

			if (getter === undefined) {
				return undefined;
			}

			return getter.call(receiver);
		}
	};

	function _inherits(subClass, superClass) {
		if (typeof superClass !== "function" && superClass !== null) {
			throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
		}

		subClass.prototype = Object.create(superClass && superClass.prototype, {
			constructor: {
				value: subClass,
				enumerable: false,
				writable: true,
				configurable: true
			}
		});
		if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
	}

	var CSS_CLASS_PLAYING = 'playing';

	/**
  * MusicPlayer
  *
  * This class creates a basic component that enhances the default behaviour of the
  * songs with 1975 london theme
  */

	var MusicPlayer = function (_State) {
		_inherits(MusicPlayer, _State);

		/**
   * @inheritDoc
   */
		function MusicPlayer(opt_config) {
			_classCallCheck(this, MusicPlayer);

			var _this = _possibleConstructorReturn(this, (MusicPlayer.__proto__ || Object.getPrototypeOf(MusicPlayer)).call(this, opt_config));

			_metal.async.nextTick(function () {
				return _this.bindUI_();
			});
			return _this;
		}

		/**
   * @inheritDoc
   */


		_createClass(MusicPlayer, [{
			key: 'disposeInternal',
			value: function disposeInternal() {
				if (this.albumClikHandle_) {
					this.albumClikHandle_.dispose();
				}

				_get(MusicPlayer.prototype.__proto__ || Object.getPrototypeOf(MusicPlayer.prototype), 'disposeInternal', this).call(this);
			}
		}, {
			key: 'bindUI_',
			value: function bindUI_() {
				var _this2 = this;

				this.on('activeAlbumChanged', this.handleActiveAlbumChanged_);

				this.albumHandle_ = _dom2.default.delegate(document.body, 'click', '.album', function (event) {
					return _this2.toggleElement_(event.delegateTarget);
				});
			}
		}, {
			key: 'handleActiveAlbumChanged_',
			value: function handleActiveAlbumChanged_(event) {
				this.stopAlbum_(event.prevVal);
				this.playAlbum_(event.newVal);
			}
		}, {
			key: 'playAlbum_',
			value: function playAlbum_(album) {
				if (album) {
					album.audio.currentTime = 0;
					album.audio.play();

					_dom2.default.addClasses(album.element, CSS_CLASS_PLAYING);

					this.updateProgressBar_();
				}
			}
		}, {
			key: 'stopAlbum_',
			value: function stopAlbum_(album) {
				if (album) {
					album.audio.pause();
					album.progressBar.style.width = '0%';

					_dom2.default.removeClasses(album.element, CSS_CLASS_PLAYING);
				}
			}
		}, {
			key: 'toggleElement_',
			value: function toggleElement_(element) {
				if (_dom2.default.hasClass(element, CSS_CLASS_PLAYING)) {
					this.activeAlbum = null;
				} else {
					this.activeAlbum = {
						audio: element.querySelector('audio'),
						element: element,
						progressBar: element.querySelector('.progress-bar')
					};
				}
			}
		}, {
			key: 'updateProgressBar_',
			value: function updateProgressBar_() {
				if (this.activeAlbum) {
					var percent = Math.ceil(this.activeAlbum.audio.currentTime / this.activeAlbum.audio.duration * 100);

					if (percent >= 100) {
						this.activeAlbum = null;
					} else if (window.requestAnimationFrame) {
						this.activeAlbum.progressBar.style.width = percent + '%';

						requestAnimationFrame(this.updateProgressBar_.bind(this));
					}
				}
			}
		}]);

		return MusicPlayer;
	}(_State3.default);

	/**
  * State definition.
  * @ignore
  * @type {!Object}
  * @static
  */
	MusicPlayer.STATE = {
		/**
   * Album being played. Should have the following properties:
   * - audio: The Audio element to be played
   * - element: The container node element
   * - progressBar: The node element to animate the progress bar
   * @instance
   * @memberof MusicPlayer
   * @type {Object<Element, Element, Audio>}
   */
		activeAlbum: {}
	};

	exports.default = MusicPlayer;
});
//# sourceMappingURL=music_player.es.js.map
