/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.messaging.handler.impl;

import jakarta.servlet.http.HttpServletRequest;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPRequestValidationHandler
extends AbstractMessageHandler {
    private final Logger log = LoggerFactory.getLogger(HTTPRequestValidationHandler.class);
    private String requiredContentType;
    private String requiredRequestMethod;
    private boolean requireSecured;
    private HttpServletRequest httpServletRequest;

    public String getRequiredContentType() {
        return this.requiredContentType;
    }

    public void setRequiredContentType(String contentType) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.requiredContentType = contentType;
        this.requiredRequestMethod = StringSupport.trimOrNull((String)contentType);
    }

    public String getRequiredRequestMethod() {
        return this.requiredRequestMethod;
    }

    public void setRequiredRequestMethod(String requestMethod) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.requiredRequestMethod = StringSupport.trimOrNull((String)requestMethod);
    }

    public boolean isRequireSecured() {
        return this.requireSecured;
    }

    public void setRequireSecured(boolean secured) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.requireSecured = secured;
    }

    public HttpServletRequest getHttpServletRequest() {
        return this.httpServletRequest;
    }

    public void setHttpServletRequest(HttpServletRequest request) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.httpServletRequest = (HttpServletRequest)Constraint.isNotNull((Object)request, (String)"HttpServletRequest may not be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        Constraint.isNotNull((Object)this.getHttpServletRequest(), (String)"HttpServletRequest may not be null");
    }

    protected void doInvoke(MessageContext messageContext) throws MessageHandlerException {
        this.evaluateContentType(this.getHttpServletRequest());
        this.evaluateRequestMethod(this.getHttpServletRequest());
        this.evaluateSecured(this.getHttpServletRequest());
    }

    protected void evaluateContentType(HttpServletRequest request) throws MessageHandlerException {
        String transportContentType = request.getHeader("Content-Type");
        if (this.getRequiredContentType() != null && !transportContentType.startsWith(this.getRequiredContentType())) {
            this.log.error("Invalid content type, expected '{}' but was '{}'", (Object)this.getRequiredContentType(), (Object)transportContentType);
            throw new MessageHandlerException("Invalid content type, expected " + this.getRequiredContentType() + " but was " + transportContentType);
        }
    }

    protected void evaluateRequestMethod(HttpServletRequest request) throws MessageHandlerException {
        String transportMethod = request.getMethod();
        if (this.getRequiredRequestMethod() != null && !transportMethod.equalsIgnoreCase(this.getRequiredRequestMethod())) {
            this.log.error("Invalid request method, expected '{}' but was '{}'", (Object)this.getRequiredRequestMethod(), (Object)transportMethod);
            throw new MessageHandlerException("Invalid request method, expected " + this.getRequiredRequestMethod() + " but was " + transportMethod);
        }
    }

    protected void evaluateSecured(HttpServletRequest request) throws MessageHandlerException {
        if (this.isRequireSecured() && !request.isSecure()) {
            this.log.error("Request was required to be secured but was not");
            throw new MessageHandlerException("Request was required to be secured but was not");
        }
    }
}

