/*
 * Decompiled with CFR 0.152.
 */
package org.jamwiki.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.DiskStoreConfiguration;
import org.jamwiki.DataAccessException;
import org.jamwiki.Environment;
import org.jamwiki.utils.Utilities;
import org.jamwiki.utils.WikiLogger;

public class WikiCache {
    private static final WikiLogger logger = WikiLogger.getLogger(WikiCache.class.getName());
    private static CacheManager cacheManager = null;
    private static final boolean USES_XML_CONFIG;
    private static final String EHCACHE_XML_CONFIG_FILENAME = "ehcache.xml";
    private static final String CACHE_DIR = "cache";

    private WikiCache() {
    }

    public static void addToCache(String cacheName, Object key, Object value) {
        Cache cache = WikiCache.getCache(cacheName);
        cache.put(new Element(key, value));
    }

    private static Cache getCache(String cacheName) throws CacheException {
        if (!cacheManager.cacheExists(cacheName)) {
            if (USES_XML_CONFIG) {
                throw new IllegalStateException("No cache named " + cacheName + " is configured in the ehcache.xml file");
            }
            int maxSize = Environment.getIntValue("cache-individual-size");
            int maxAge = Environment.getIntValue("cache-max-age");
            int maxIdleAge = Environment.getIntValue("cache-max-idle-age");
            Cache cache = new Cache(cacheName, maxSize, true, false, (long)maxAge, (long)maxIdleAge);
            cacheManager.addCache(cache);
        }
        return cacheManager.getCache(cacheName);
    }

    public static void initialize() {
        try {
            File directory;
            if (cacheManager != null) {
                if (USES_XML_CONFIG) {
                    cacheManager.removalAll();
                }
                cacheManager.shutdown();
            }
            if (!(directory = new File(Environment.getValue("homeDir"), CACHE_DIR)).exists()) {
                directory.mkdir();
            }
            if (USES_XML_CONFIG) {
                cacheManager = CacheManager.create();
            } else {
                Configuration configuration = new Configuration();
                CacheConfiguration defaultCacheConfiguration = new CacheConfiguration("jamwikiCache", Environment.getIntValue("cache-total-size"));
                defaultCacheConfiguration.setDiskPersistent(false);
                defaultCacheConfiguration.setEternal(false);
                defaultCacheConfiguration.setOverflowToDisk(true);
                configuration.addDefaultCache(defaultCacheConfiguration);
                DiskStoreConfiguration diskStoreConfiguration = new DiskStoreConfiguration();
                diskStoreConfiguration.setPath(directory.getPath());
                configuration.addDiskStore(diskStoreConfiguration);
                cacheManager = new CacheManager(configuration);
            }
        }
        catch (Exception e) {
            logger.error("Failure while initializing cache", e);
            throw new RuntimeException(e);
        }
        logger.info("Initializing cache 9");
    }

    public static void shutdown() {
        if (cacheManager != null) {
            cacheManager.shutdown();
            cacheManager = null;
        }
    }

    public static String key(String value1, String value2) {
        if (value1 == null && value2 == null) {
            throw new IllegalArgumentException("WikiCache.key cannot be called with two null values");
        }
        if (value1 == null) {
            value1 = "";
        }
        if (value2 == null) {
            value2 = "";
        }
        return value1 + "/" + value2;
    }

    public static void removeAllFromCache(String cacheName) {
        Cache cache = WikiCache.getCache(cacheName);
        cache.removeAll();
    }

    public static void removeCache(String cacheName) {
        cacheManager.removeCache(cacheName);
    }

    public static void removeFromCache(String cacheName, Object key) {
        Cache cache = WikiCache.getCache(cacheName);
        cache.remove(key);
    }

    public static void removeFromCacheCaseInsensitive(String cacheName, String key) {
        Cache cache = WikiCache.getCache(cacheName);
        List cacheKeys = cache.getKeys();
        for (Object cacheKey : cacheKeys) {
            if (!cacheKey.toString().equalsIgnoreCase(key)) continue;
            cache.remove(cacheKey);
        }
    }

    public static Element retrieveFromCache(String cacheName, Object key) throws DataAccessException {
        Cache cache = null;
        try {
            cache = WikiCache.getCache(cacheName);
        }
        catch (CacheException e) {
            throw new DataAccessException("Failure while retrieving data from cache " + cacheName, e);
        }
        return cache.get(key);
    }

    static {
        boolean xmlConfig = false;
        try {
            Utilities.getClassLoaderFile(EHCACHE_XML_CONFIG_FILENAME);
            logger.info("Initializing cache configuration from ehcache.xml file");
            xmlConfig = true;
        }
        catch (FileNotFoundException e) {
            logger.info("No ehcache.xml file found, using default cache configuration");
        }
        USES_XML_CONFIG = xmlConfig;
        WikiCache.initialize();
    }
}

