/*
 * Decompiled with CFR 0.152.
 */
package org.jamwiki.parser.jflex;

import org.jamwiki.parser.ParserException;
import org.jamwiki.parser.jflex.JFlexLexer;
import org.jamwiki.parser.jflex.JFlexParserTag;
import org.jamwiki.parser.jflex.JFlexTagItem;
import org.jamwiki.utils.WikiLogger;

public class WikiBoldItalicTag
implements JFlexParserTag {
    private static final WikiLogger logger = WikiLogger.getLogger(WikiBoldItalicTag.class.getName());

    public String parse(JFlexLexer lexer, String raw, Object ... args) {
        if (logger.isTraceEnabled()) {
            logger.trace("bold / italic: " + raw + " (" + lexer.yystate() + ")");
        }
        if (args.length == 0) {
            throw new IllegalArgumentException("Must pass heading depth to WikiHeadingTag.parse");
        }
        try {
            this.processBoldItalic(lexer, (String)args[0]);
        }
        catch (ParserException e) {
            logger.info("Failure while parsing: " + raw, e);
            return raw;
        }
        return "";
    }

    private void processBoldItalic(JFlexLexer lexer, String tagType) throws ParserException {
        JFlexTagItem grandparent;
        int stackLength;
        if (tagType == null) {
            if (lexer.peekTag().getTagType().equals("i")) {
                this.processBoldItalic(lexer, "i");
                this.processBoldItalic(lexer, "b");
            } else {
                this.processBoldItalic(lexer, "b");
                this.processBoldItalic(lexer, "i");
            }
            return;
        }
        if (lexer.peekTag().getTagType().equals(tagType)) {
            lexer.popTag(tagType);
            return;
        }
        if (tagType.equals("b") && lexer.peekTag().getTagType().equals("i") && (stackLength = lexer.getTagStack().size()) > 2 && (grandparent = (JFlexTagItem)lexer.getTagStack().get(stackLength - 2)).getTagType().equals("b")) {
            grandparent.changeTagType("i");
            lexer.peekTag().changeTagType("b");
            lexer.popTag(tagType);
            return;
        }
        lexer.pushTag(tagType, null);
    }
}

