/*
 * Decompiled with CFR 0.152.
 */
package org.jamwiki.parser;

import java.util.Hashtable;
import java.util.Locale;
import org.jamwiki.Environment;
import org.jamwiki.model.WikiUser;
import org.jamwiki.parser.ExcessiveNestingException;
import org.jamwiki.parser.TableOfContents;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserInput {
    private boolean allowSectionEdit = true;
    private String context = null;
    private int depth = 0;
    private int infiniteLoopCount = 0;
    private Locale locale = null;
    private TableOfContents tableOfContents = new TableOfContents();
    private int templateDepth = 0;
    private final Hashtable<String, Object> tempParams = new Hashtable();
    private String topicName = null;
    private String userDisplay = null;
    private String virtualWiki = null;
    private WikiUser wikiUser = null;

    public ParserInput(String virtualWiki, String topicName) {
        this.virtualWiki = virtualWiki;
        this.topicName = topicName;
    }

    public ParserInput(ParserInput parserInput) {
        this.allowSectionEdit = parserInput.allowSectionEdit;
        this.context = parserInput.context;
        this.depth = this.depth;
        this.infiniteLoopCount = this.infiniteLoopCount;
        this.locale = parserInput.locale;
        this.templateDepth = this.templateDepth;
        this.topicName = parserInput.topicName;
        this.userDisplay = parserInput.userDisplay;
        this.virtualWiki = parserInput.virtualWiki;
        this.wikiUser = parserInput.wikiUser;
    }

    public boolean getAllowSectionEdit() {
        return this.allowSectionEdit;
    }

    public void setAllowSectionEdit(boolean allowSectionEdit) {
        this.allowSectionEdit = allowSectionEdit;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public int getDepth() {
        return this.depth;
    }

    public void decrementDepth() {
        --this.depth;
    }

    public void incrementDepth() throws ExcessiveNestingException {
        if (this.getDepth() + 1 >= Environment.getIntValue("parser-max-iterations")) {
            ++this.infiniteLoopCount;
            throw new ExcessiveNestingException("Potential infinite parsing loop - over " + this.getDepth() + " parser iterations while parsing topic " + this.getTopicName());
        }
        ++this.depth;
    }

    public int getInfiniteLoopCount() {
        return this.infiniteLoopCount;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public TableOfContents getTableOfContents() {
        return this.tableOfContents;
    }

    public void setTableOfContents(TableOfContents tableOfContents) {
        this.tableOfContents = tableOfContents;
    }

    public Hashtable<String, Object> getTempParams() {
        return this.tempParams;
    }

    public int getTemplateDepth() {
        return this.templateDepth;
    }

    public void decrementTemplateDepth() {
        --this.templateDepth;
    }

    public void incrementTemplateDepth() {
        ++this.templateDepth;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public String getUserDisplay() {
        return this.userDisplay;
    }

    public void setUserDisplay(String userDisplay) {
        this.userDisplay = userDisplay;
    }

    public String getVirtualWiki() {
        return this.virtualWiki;
    }

    public WikiUser getWikiUser() {
        return this.wikiUser;
    }

    public void setWikiUser(WikiUser user) {
        this.wikiUser = user;
    }
}

