/*
 * Decompiled with CFR 0.152.
 */
package org.jamwiki.migrate;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jamwiki.DataAccessException;
import org.jamwiki.WikiBase;
import org.jamwiki.migrate.MediaWikiConstants;
import org.jamwiki.migrate.MigrationException;
import org.jamwiki.migrate.TopicExporter;
import org.jamwiki.model.Namespace;
import org.jamwiki.model.RecentChange;
import org.jamwiki.model.Topic;
import org.jamwiki.model.TopicVersion;
import org.jamwiki.model.VirtualWiki;
import org.jamwiki.model.WikiUser;
import org.jamwiki.utils.Pagination;
import org.jamwiki.utils.Utilities;
import org.jamwiki.utils.WikiLogger;
import org.jamwiki.utils.WikiUtil;
import org.jamwiki.utils.XMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaWikiXmlExporter
implements TopicExporter {
    private static final WikiLogger logger = WikiLogger.getLogger(MediaWikiXmlExporter.class.getName());

    @Override
    public void exportToFile(File file, String virtualWiki, List<String> topicNames, boolean excludeHistory) throws MigrationException {
        FileWriter writer = null;
        boolean success = false;
        try {
            writer = new FileWriter(file);
            writer.write("<mediawiki xmlns=\"http://www.mediawiki.org/xml/export-0.3/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.mediawiki.org/xml/export-0.3/ http://www.mediawiki.org/xml/export-0.3.xsd\" version=\"0.3\" xml:lang=\"en\">");
            this.writeSiteInfo(writer, virtualWiki);
            this.writePages(writer, virtualWiki, topicNames, excludeHistory);
            writer.write("\n</mediawiki>");
            success = true;
        }
        catch (DataAccessException e) {
            throw new MigrationException(e);
        }
        catch (IOException e) {
            throw new MigrationException(e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException ignore) {}
            }
            if (!success) {
                file.delete();
            }
        }
    }

    private void writeSiteInfo(FileWriter writer, String virtualWikiName) throws DataAccessException, IOException {
        VirtualWiki virtualWiki = WikiBase.getDataHandler().lookupVirtualWiki(virtualWikiName);
        writer.write("\n<siteinfo>");
        String sitename = virtualWiki.getSiteName();
        writer.write('\n' + XMLUtil.buildTag("sitename", sitename, true));
        String base = WikiUtil.getBaseUrl();
        writer.write('\n' + XMLUtil.buildTag("base", base, true));
        String generator = "JAMWiki 1.0.7";
        writer.write('\n' + XMLUtil.buildTag("generator", generator, true));
        writer.write('\n' + XMLUtil.buildTag("case", "case-sensitive", true));
        writer.write("\n<namespaces>");
        HashMap<String, String> attributes = new HashMap<String, String>();
        String namespace = null;
        for (Integer key : MediaWikiConstants.MEDIAWIKI_NAMESPACE_MAP.keySet()) {
            namespace = MediaWikiConstants.MEDIAWIKI_NAMESPACE_MAP.get(key);
            attributes.put("key", key.toString());
            writer.write('\n' + XMLUtil.buildTag("namespace", namespace, attributes, true));
        }
        writer.write("\n</namespaces>");
        writer.write("\n</siteinfo>");
    }

    private void writePages(FileWriter writer, String virtualWiki, List<String> topicNames, boolean excludeHistory) throws DataAccessException, IOException, MigrationException {
        Pagination pagination = new Pagination(100000, 0);
        HashMap<String, String> textAttributes = new HashMap<String, String>();
        textAttributes.put("xml:space", "preserve");
        for (String topicName : topicNames) {
            ArrayList<Integer> topicVersionIds = new ArrayList<Integer>();
            Topic topic = WikiBase.getDataHandler().lookupTopic(virtualWiki, topicName, false, null);
            if (topic == null) {
                throw new MigrationException("Failure while exporting: topic " + topicName + " does not exist");
            }
            writer.write("\n<page>");
            writer.write('\n' + XMLUtil.buildTag("title", topic.getName(), true));
            writer.write('\n' + XMLUtil.buildTag("id", topic.getTopicId()));
            if (excludeHistory) {
                topicVersionIds.add(topic.getCurrentVersionId());
            } else {
                List<RecentChange> changes = WikiBase.getDataHandler().getTopicHistory(virtualWiki, topicName, pagination, true);
                for (int i = changes.size() - 1; i >= 0; --i) {
                    topicVersionIds.add(changes.get(i).getTopicVersionId());
                }
            }
            Iterator i$ = topicVersionIds.iterator();
            while (i$.hasNext()) {
                WikiUser user;
                int topicVersionId = (Integer)i$.next();
                TopicVersion topicVersion = WikiBase.getDataHandler().lookupTopicVersion(topicVersionId);
                writer.write("\n<revision>");
                writer.write('\n' + XMLUtil.buildTag("id", topicVersion.getTopicVersionId()));
                writer.write('\n' + XMLUtil.buildTag("timestamp", this.parseJAMWikiTimestamp(topicVersion.getEditDate()), true));
                writer.write("\n<contributor>");
                WikiUser wikiUser = user = topicVersion.getAuthorId() != null ? WikiBase.getDataHandler().lookupWikiUser(topicVersion.getAuthorId()) : null;
                if (user != null) {
                    writer.write('\n' + XMLUtil.buildTag("username", user.getUsername(), true));
                    writer.write('\n' + XMLUtil.buildTag("id", user.getUserId()));
                } else if (Utilities.isIpAddress(topicVersion.getAuthorDisplay())) {
                    writer.write('\n' + XMLUtil.buildTag("ip", topicVersion.getAuthorDisplay(), true));
                } else {
                    writer.write('\n' + XMLUtil.buildTag("username", topicVersion.getAuthorDisplay(), true));
                }
                writer.write("\n</contributor>");
                writer.write('\n' + XMLUtil.buildTag("comment", topicVersion.getEditComment(), true));
                String versionContent = this.convertToMediawikiNamespaces(virtualWiki, topicVersion.getVersionContent());
                writer.write('\n' + XMLUtil.buildTag("text", versionContent, textAttributes, true));
                writer.write("\n</revision>");
            }
            writer.write("\n</page>");
        }
    }

    private String parseJAMWikiTimestamp(Timestamp timestamp) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        return sdf.format(timestamp);
    }

    private String convertToMediawikiNamespaces(String virtualWiki, String text) throws DataAccessException {
        StringBuilder builder = new StringBuilder(text);
        int start = 0;
        for (Integer key : MediaWikiConstants.MEDIAWIKI_NAMESPACE_MAP.keySet()) {
            Namespace jamwikiNamespace = WikiBase.getDataHandler().lookupNamespaceById(key);
            String mediawikiNamespace = MediaWikiConstants.MEDIAWIKI_NAMESPACE_MAP.get(key);
            if (jamwikiNamespace == null || StringUtils.equals((String)jamwikiNamespace.getLabel(virtualWiki), (String)mediawikiNamespace)) continue;
            String mediawikiPattern = "[[" + mediawikiNamespace + ":";
            String jamwikiPattern = "[[" + jamwikiNamespace.getLabel(virtualWiki) + ":";
            while ((start = builder.indexOf(jamwikiPattern, start + 1)) != -1) {
                builder.replace(start, start + jamwikiPattern.length(), mediawikiPattern);
            }
        }
        return builder.toString();
    }
}

