/*
 * Decompiled with CFR 0.152.
 */
package org.jamwiki.db;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.jamwiki.DataAccessException;
import org.jamwiki.WikiBase;
import org.jamwiki.WikiException;
import org.jamwiki.WikiMessage;
import org.jamwiki.db.DatabaseConnection;
import org.jamwiki.db.WikiDatabase;
import org.jamwiki.utils.WikiLogger;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseUpgrades {
    private static final WikiLogger logger = WikiLogger.getLogger(DatabaseUpgrades.class.getName());

    private DatabaseUpgrades() {
    }

    private static TransactionDefinition getTransactionDefinition() {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(3);
        return def;
    }

    public static boolean login(String username, String password) throws WikiException {
        try {
            return WikiBase.getDataHandler().authenticate(username, password);
        }
        catch (DataAccessException e) {
            logger.error("Unable to authenticate user during upgrade", e);
            throw new WikiException(new WikiMessage("upgrade.error.fatal", e.getMessage()));
        }
    }

    public static List<WikiMessage> upgrade090(List<WikiMessage> messages) throws WikiException {
        Connection conn;
        TransactionStatus status = null;
        try {
            status = DatabaseConnection.startTransaction(DatabaseUpgrades.getTransactionDefinition());
            conn = DatabaseConnection.getConnection();
            WikiBase.getDataHandler().executeUpgradeUpdate("STATEMENT_CREATE_NAMESPACE_TABLE", conn);
            messages.add(new WikiMessage("upgrade.message.db.table.added", "jam_namespace"));
            WikiBase.getDataHandler().executeUpgradeUpdate("STATEMENT_CREATE_NAMESPACE_TRANSLATION_TABLE", conn);
            messages.add(new WikiMessage("upgrade.message.db.table.added", "jam_namespace_translation"));
            WikiDatabase.setupDefaultNamespaces();
            messages.add(new WikiMessage("upgrade.message.db.data.added", "jam_namespace"));
            WikiBase.getDataHandler().executeUpgradeUpdate("UPGRADE_090_ADD_TOPIC_NAMESPACE_ID", conn);
            WikiBase.getDataHandler().executeUpgradeUpdate("UPGRADE_090_ADD_TOPIC_NAMESPACE_ID_CONSTRAINT", conn);
            messages.add(new WikiMessage("upgrade.message.db.column.added", "namespace_id", "jam_topic"));
            WikiBase.getDataHandler().executeUpgradeUpdate("UPGRADE_090_ADD_TOPIC_PAGE_NAME", conn);
            messages.add(new WikiMessage("upgrade.message.db.column.added", "page_name", "jam_topic"));
            WikiBase.getDataHandler().executeUpgradeUpdate("UPGRADE_090_ADD_TOPIC_PAGE_NAME_LOWER", conn);
            messages.add(new WikiMessage("upgrade.message.db.column.added", "page_name_lower", "jam_topic"));
            WikiBase.getDataHandler().executeUpgradeUpdate("STATEMENT_CREATE_TOPIC_VERSION_TOPIC_INDEX", conn);
            messages.add(new WikiMessage("upgrade.message.db.data.updated", "jam_topic_version"));
        }
        catch (SQLException e) {
            DatabaseConnection.rollbackOnException(status, e);
            logger.error("Database failure during upgrade", e);
            throw new WikiException(new WikiMessage("upgrade.error.fatal", e.getMessage()));
        }
        catch (DataAccessException e) {
            DatabaseConnection.rollbackOnException(status, e);
            logger.error("Database failure during upgrade", e);
            throw new WikiException(new WikiMessage("upgrade.error.fatal", e.getMessage()));
        }
        DatabaseConnection.commit(status);
        try {
            status = DatabaseConnection.startTransaction(DatabaseUpgrades.getTransactionDefinition());
            conn = DatabaseConnection.getConnection();
            int numUpdated = WikiDatabase.fixIncorrectTopicNamespaces();
            messages.add(new WikiMessage("admin.maintenance.message.topicsUpdated", Integer.toString(numUpdated)));
            WikiBase.getDataHandler().executeUpgradeUpdate("UPGRADE_090_ADD_TOPIC_PAGE_NAME_NOT_NULL_CONSTRAINT", conn);
            messages.add(new WikiMessage("upgrade.message.db.column.modified", "page_name", "jam_topic"));
            WikiBase.getDataHandler().executeUpgradeUpdate("UPGRADE_090_ADD_TOPIC_PAGE_NAME_LOWER_NOT_NULL_CONSTRAINT", conn);
            messages.add(new WikiMessage("upgrade.message.db.column.modified", "page_name_lower", "jam_topic"));
            WikiBase.getDataHandler().executeUpgradeUpdate("STATEMENT_CREATE_TOPIC_PAGE_NAME_INDEX", conn);
            WikiBase.getDataHandler().executeUpgradeUpdate("STATEMENT_CREATE_TOPIC_PAGE_NAME_LOWER_INDEX", conn);
        }
        catch (SQLException e) {
            messages.add(new WikiMessage("upgrade.error.nonfatal", e.getMessage()));
            logger.warn("Failure while populating correct namespace_id values in the jam_topic table.  Try running the 'Fix Incorrect Topic Namespaces' from Special:Maintenance to complete this step.", e);
            try {
                DatabaseConnection.rollbackOnException(status, e);
            }
            catch (Exception ex) {
                // empty catch block
            }
            status = null;
        }
        catch (DataAccessException e) {
            messages.add(new WikiMessage("upgrade.error.nonfatal", e.getMessage()));
            logger.warn("Failure while populating correct namespace_id values in the jam_topic table.  Try running the 'Fix Incorrect Topic Namespaces' from Special:Maintenance to complete this step.", e);
            try {
                DatabaseConnection.rollbackOnException(status, e);
            }
            catch (Exception exception) {
                // empty catch block
            }
            status = null;
        }
        if (status != null) {
            DatabaseConnection.commit(status);
        }
        return messages;
    }

    public static List<WikiMessage> preUpgrade100(List<WikiMessage> messages) throws WikiException {
        TransactionStatus status = null;
        try {
            status = DatabaseConnection.startTransaction(DatabaseUpgrades.getTransactionDefinition());
            Connection conn = DatabaseConnection.getConnection();
            WikiBase.getDataHandler().executeUpgradeUpdate("UPGRADE_100_ADD_VIRTUAL_WIKI_LOGO_URL", conn);
            messages.add(new WikiMessage("upgrade.message.db.column.added", "logo_image_url", "jam_virtual_wiki"));
            WikiBase.getDataHandler().executeUpgradeUpdate("UPGRADE_100_ADD_VIRTUAL_WIKI_SITE_NAME", conn);
            messages.add(new WikiMessage("upgrade.message.db.column.added", "site_name", "jam_virtual_wiki"));
            WikiBase.getDataHandler().executeUpgradeUpdate("UPGRADE_100_ADD_VIRTUAL_WIKI_META_DESCRIPTION", conn);
            messages.add(new WikiMessage("upgrade.message.db.column.added", "meta_description", "jam_virtual_wiki"));
        }
        catch (SQLException e) {
            DatabaseConnection.rollbackOnException(status, e);
            logger.error("Database failure during upgrade", e);
            throw new WikiException(new WikiMessage("upgrade.error.fatal", e.getMessage()));
        }
        DatabaseConnection.commit(status);
        return messages;
    }

    public static List<WikiMessage> upgrade100(List<WikiMessage> messages) throws WikiException {
        Connection conn;
        TransactionStatus status = null;
        try {
            status = DatabaseConnection.startTransaction(DatabaseUpgrades.getTransactionDefinition());
            conn = DatabaseConnection.getConnection();
            WikiBase.getDataHandler().executeUpgradeUpdate("STATEMENT_CREATE_TOPIC_LINKS_TABLE", conn);
            messages.add(new WikiMessage("upgrade.message.db.table.added", "jam_topic_links"));
            WikiBase.getDataHandler().executeUpgradeUpdate("STATEMENT_CREATE_INTERWIKI_TABLE", conn);
            WikiDatabase.setupDefaultInterwikis();
            messages.add(new WikiMessage("upgrade.message.db.data.added", "jam_interwiki"));
            WikiBase.getDataHandler().executeUpgradeUpdate("STATEMENT_CREATE_CONFIGURATION_TABLE", conn);
            messages.add(new WikiMessage("upgrade.message.db.table.added", "jam_configuration"));
            WikiBase.getDataHandler().executeUpgradeUpdate("UPGRADE_100_DROP_VIRTUAL_WIKI_DEFAULT_TOPIC_NOT_NULL", conn);
            messages.add(new WikiMessage("upgrade.message.db.column.modified", "default_topic_name", "jam_virtual_wiki"));
        }
        catch (DataAccessException e) {
            DatabaseConnection.rollbackOnException(status, e);
            logger.error("Database failure during upgrade", e);
            throw new WikiException(new WikiMessage("upgrade.error.fatal", e.getMessage()));
        }
        catch (SQLException e) {
            DatabaseConnection.rollbackOnException(status, e);
            logger.error("Database failure during upgrade", e);
            throw new WikiException(new WikiMessage("upgrade.error.fatal", e.getMessage()));
        }
        DatabaseConnection.commit(status);
        try {
            status = DatabaseConnection.startTransaction(DatabaseUpgrades.getTransactionDefinition());
            conn = DatabaseConnection.getConnection();
            WikiBase.getDataHandler().executeUpgradeUpdate("STATEMENT_CREATE_TOPIC_LINKS_INDEX", conn);
            messages.add(new WikiMessage("upgrade.message.db.data.updated", "jam_topic_links"));
            WikiBase.getDataHandler().executeUpgradeUpdate("STATEMENT_CREATE_CATEGORY_INDEX", conn);
            messages.add(new WikiMessage("upgrade.message.db.data.updated", "jam_category"));
            WikiBase.getDataHandler().executeUpgradeUpdate("STATEMENT_CREATE_TOPIC_CURRENT_VERSION_INDEX", conn);
            WikiBase.getDataHandler().executeUpgradeUpdate("STATEMENT_CREATE_TOPIC_NAMESPACE_INDEX", conn);
            WikiBase.getDataHandler().executeUpgradeUpdate("STATEMENT_CREATE_TOPIC_VIRTUAL_WIKI_INDEX", conn);
            messages.add(new WikiMessage("upgrade.message.db.data.updated", "jam_topic"));
            WikiBase.getDataHandler().executeUpgradeUpdate("STATEMENT_CREATE_TOPIC_VERSION_PREVIOUS_INDEX", conn);
            WikiBase.getDataHandler().executeUpgradeUpdate("STATEMENT_CREATE_TOPIC_VERSION_USER_DISPLAY_INDEX", conn);
            WikiBase.getDataHandler().executeUpgradeUpdate("STATEMENT_CREATE_TOPIC_VERSION_USER_ID_INDEX", conn);
            messages.add(new WikiMessage("upgrade.message.db.data.updated", "jam_topic_version"));
        }
        catch (SQLException e) {
            messages.add(new WikiMessage("upgrade.error.nonfatal", e.getMessage()));
            logger.warn("Non-fatal error while upgrading.", e);
            try {
                DatabaseConnection.rollbackOnException(status, e);
            }
            catch (Exception exception) {
                // empty catch block
            }
            status = null;
        }
        if (status != null) {
            DatabaseConnection.commit(status);
        }
        return messages;
    }
}

