/*
 * Decompiled with CFR 0.152.
 */
package org.jamwiki.db;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.lang.StringUtils;
import org.jamwiki.Environment;
import org.jamwiki.db.LocalDataSource;
import org.jamwiki.db.WikiDatabase;
import org.jamwiki.utils.Utilities;
import org.jamwiki.utils.WikiLogger;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.datasource.DelegatingDataSource;
import org.springframework.jdbc.datasource.LazyConnectionDataSourceProxy;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class DatabaseConnection {
    private static final WikiLogger logger = WikiLogger.getLogger(DatabaseConnection.class.getName());
    protected static final int SLOW_QUERY_LIMIT = 250;
    private static DataSource dataSource = null;
    private static DataSourceTransactionManager transactionManager = null;

    private DatabaseConnection() {
    }

    protected static void closeConnection(Connection conn, Statement stmt, ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        DatabaseConnection.closeConnection(conn, stmt);
    }

    protected static void closeConnection(Connection conn, Statement stmt) {
        DatabaseConnection.closeStatement(stmt);
        DatabaseConnection.closeConnection(conn);
    }

    protected static void closeConnection(Connection conn) {
        if (conn == null) {
            return;
        }
        DataSourceUtils.releaseConnection((Connection)conn, (DataSource)dataSource);
    }

    protected static void closeConnectionPool() throws SQLException {
        try {
            DataSource testDataSource = dataSource;
            while (testDataSource instanceof DelegatingDataSource) {
                testDataSource = ((DelegatingDataSource)testDataSource).getTargetDataSource();
            }
            if (testDataSource instanceof BasicDataSource) {
                ((BasicDataSource)testDataSource).close();
            }
        }
        catch (SQLException e) {
            logger.error("Unable to close connection pool", e);
            throw e;
        }
        dataSource = null;
        transactionManager = null;
    }

    protected static void closeStatement(Statement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int executeSequenceQuery(String sql, String field, Connection conn) throws SQLException {
        int n;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            n = rs.next() ? rs.getInt(field) : 0;
        }
        catch (Throwable throwable) {
            DatabaseConnection.closeConnection(null, stmt, rs);
            throw throwable;
        }
        DatabaseConnection.closeConnection(null, stmt, rs);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void executeUpdate(String sql) throws SQLException {
        Connection conn = null;
        try {
            conn = DatabaseConnection.getConnection();
            DatabaseConnection.executeUpdate(sql, conn);
        }
        finally {
            if (conn != null) {
                DatabaseConnection.closeConnection(conn);
            }
        }
    }

    protected static int executeUpdate(String sql, Connection conn) throws SQLException {
        int n;
        Statement stmt = null;
        try {
            long start = System.currentTimeMillis();
            stmt = conn.createStatement();
            logger.info("Executing SQL: " + sql);
            int result = stmt.executeUpdate(sql);
            long execution = System.currentTimeMillis() - start;
            if (execution > 250L) {
                logger.warn("Slow query: " + sql + " (" + (double)execution / 1000.0 + " s.)");
            }
            logger.debug("Executed " + sql + " (" + (double)execution / 1000.0 + " s.)");
            n = result;
        }
        catch (SQLException e) {
            try {
                logger.error("Failure while executing " + sql, e);
                throw e;
            }
            catch (Throwable throwable) {
                DatabaseConnection.closeStatement(stmt);
                throw throwable;
            }
        }
        DatabaseConnection.closeStatement(stmt);
        return n;
    }

    protected static Connection getConnection() throws SQLException {
        if (dataSource == null) {
            DatabaseConnection.configDataSource();
        }
        return DataSourceUtils.getConnection((DataSource)dataSource);
    }

    private static synchronized void configDataSource() throws SQLException {
        if (dataSource != null) {
            DatabaseConnection.closeConnectionPool();
        }
        String url = Environment.getValue("url");
        Object targetDataSource = null;
        if (url.startsWith("jdbc:")) {
            try {
                targetDataSource = new LocalDataSource();
            }
            catch (ClassNotFoundException e) {
                logger.error("Failure while configuring local data source", e);
                throw new SQLException("Failure while configuring local data source: " + e.toString());
            }
        }
        try {
            InitialContext ctx = new InitialContext();
            targetDataSource = (DataSource)ctx.lookup(url);
        }
        catch (NamingException e) {
            logger.error("Failure while configuring JNDI data source with URL: " + url, e);
            throw new SQLException("Unable to configure JNDI data source with URL " + url + ": " + e.toString());
        }
        dataSource = new LazyConnectionDataSourceProxy((DataSource)targetDataSource);
        transactionManager = new DataSourceTransactionManager((DataSource)targetDataSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testDatabase(String driver, String url, String user, String password, boolean existence) throws SQLException, ClassNotFoundException {
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = DatabaseConnection.getTestConnection(driver, url, user, password);
            if (existence) {
                stmt = conn.createStatement();
                stmt.executeQuery(WikiDatabase.getExistenceValidationQuery());
            }
        }
        catch (Throwable throwable) {
            DatabaseConnection.closeConnection(conn, stmt);
            throw throwable;
        }
        DatabaseConnection.closeConnection(conn, stmt);
    }

    protected static Connection getTestConnection(String driver, String url, String user, String password) throws SQLException {
        if (url.startsWith("jdbc:")) {
            if (!StringUtils.isBlank((String)driver)) {
                try {
                    Utilities.forName(driver);
                }
                catch (ClassNotFoundException e) {
                    throw new SQLException("Unable to instantiate class with name: " + driver);
                }
            }
            return DriverManager.getConnection(url, user, password);
        }
        DataSource testDataSource = null;
        try {
            InitialContext ctx = new InitialContext();
            testDataSource = (DataSource)ctx.lookup(url);
        }
        catch (NamingException e) {
            logger.error("Failure while configuring JNDI data source with URL: " + url, e);
            throw new SQLException("Unable to configure JNDI data source with URL " + url + ": " + e.toString());
        }
        return testDataSource.getConnection();
    }

    public static TransactionStatus startTransaction() throws SQLException {
        return DatabaseConnection.startTransaction((TransactionDefinition)new DefaultTransactionDefinition());
    }

    protected static TransactionStatus startTransaction(TransactionDefinition definition) throws SQLException {
        if (transactionManager == null || dataSource == null) {
            DatabaseConnection.configDataSource();
        }
        return transactionManager.getTransaction(definition);
    }

    protected static void rollbackOnException(TransactionStatus status, Throwable ex) throws TransactionException {
        logger.debug("Initiating transaction rollback on application exception", ex);
        if (status == null) {
            logger.info("TransactionStatus is null, unable to rollback");
            return;
        }
        try {
            transactionManager.rollback(status);
        }
        catch (TransactionSystemException ex2) {
            logger.error("Application exception overridden by rollback exception", ex);
            ex2.initApplicationException(ex);
            throw ex2;
        }
        catch (RuntimeException ex2) {
            logger.error("Application exception overridden by rollback exception", ex);
            throw ex2;
        }
        catch (Error err) {
            logger.error("Application exception overridden by rollback error", ex);
            throw err;
        }
    }

    protected static void commit(TransactionStatus status) {
        if (status == null) {
            logger.info("TransactionStatus is null, unable to commit");
            return;
        }
        transactionManager.commit(status);
    }
}

