/*
 * Decompiled with CFR 0.152.
 */
package org.jabsorb.serializer.impl;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.jabsorb.JSONSerializer;
import org.jabsorb.serializer.AbstractSerializer;
import org.jabsorb.serializer.MarshallException;
import org.jabsorb.serializer.ObjectMatch;
import org.jabsorb.serializer.SerializerState;
import org.jabsorb.serializer.UnmarshallException;
import org.json.JSONException;
import org.json.JSONObject;

public class MapSerializer
extends AbstractSerializer {
    private static final long serialVersionUID = 2L;
    private static Class[] _serializableClasses = new Class[]{Map.class, HashMap.class, TreeMap.class, LinkedHashMap.class};
    private static Class[] _JSONClasses = new Class[]{JSONObject.class};

    public boolean canSerialize(Class clazz, Class jsonClazz) {
        return super.canSerialize(clazz, jsonClazz) || (jsonClazz == null || jsonClazz == JSONObject.class) && Map.class.isAssignableFrom(clazz);
    }

    public Class[] getJSONClasses() {
        return _JSONClasses;
    }

    public Class[] getSerializableClasses() {
        return _serializableClasses;
    }

    public Object marshall(SerializerState state, Object p, Object o) throws MarshallException {
        Map map = (Map)o;
        JSONObject obj = new JSONObject();
        JSONObject mapdata = new JSONObject();
        if (this.ser.getMarshallClassHints()) {
            try {
                obj.put("javaClass", (Object)o.getClass().getName());
            }
            catch (JSONException e) {
                throw new MarshallException("javaClass not found!", e);
            }
        }
        try {
            obj.put("map", (Object)mapdata);
            state.push(o, mapdata, "map");
        }
        catch (JSONException e) {
            throw new MarshallException("Could not add map to object: " + e.getMessage(), e);
        }
        Object key = null;
        try {
            for (Map.Entry ent : map.entrySet()) {
                key = ent.getKey();
                String keyString = key.toString();
                Object json = this.ser.marshall(state, mapdata, ent.getValue(), keyString);
                if (JSONSerializer.CIRC_REF_OR_DUPLICATE == json) continue;
                mapdata.put(keyString, json);
            }
        }
        catch (MarshallException e) {
            throw new MarshallException("map key " + key + " " + e.getMessage(), e);
        }
        catch (JSONException e) {
            throw new MarshallException("map key " + key + " " + e.getMessage(), e);
        }
        finally {
            state.pop();
        }
        return obj;
    }

    public ObjectMatch tryUnmarshall(SerializerState state, Class clazz, Object o) throws UnmarshallException {
        JSONObject jsonmap;
        String java_class;
        JSONObject jso = (JSONObject)o;
        try {
            java_class = jso.getString("javaClass");
        }
        catch (JSONException e) {
            throw new UnmarshallException("Could not read javaClass", e);
        }
        if (java_class == null) {
            throw new UnmarshallException("no type hint");
        }
        if (!(java_class.equals("java.util.Map") || java_class.equals("java.util.AbstractMap") || java_class.equals("java.util.LinkedHashMap") || java_class.equals("java.util.TreeMap") || java_class.equals("java.util.HashMap"))) {
            throw new UnmarshallException("not a Map");
        }
        try {
            jsonmap = jso.getJSONObject("map");
        }
        catch (JSONException e) {
            throw new UnmarshallException("Could not read map: " + e.getMessage(), e);
        }
        if (jsonmap == null) {
            throw new UnmarshallException("map missing");
        }
        ObjectMatch m = new ObjectMatch(-1);
        Iterator i = jsonmap.keys();
        String key = null;
        state.setSerialized(o, m);
        try {
            while (i.hasNext()) {
                key = (String)i.next();
                m.setMismatch(this.ser.tryUnmarshall(state, null, jsonmap.get(key)).max(m).getMismatch());
            }
        }
        catch (UnmarshallException e) {
            throw new UnmarshallException("key " + key + " " + e.getMessage(), e);
        }
        catch (JSONException e) {
            throw new UnmarshallException("key " + key + " " + e.getMessage(), e);
        }
        return m;
    }

    public Object unmarshall(SerializerState state, Class clazz, Object o) throws UnmarshallException {
        JSONObject jsonmap;
        AbstractMap abmap;
        String java_class;
        JSONObject jso = (JSONObject)o;
        try {
            java_class = jso.getString("javaClass");
        }
        catch (JSONException e) {
            throw new UnmarshallException("Could not read javaClass", e);
        }
        if (java_class == null) {
            throw new UnmarshallException("no type hint");
        }
        if (java_class.equals("java.util.Map") || java_class.equals("java.util.AbstractMap") || java_class.equals("java.util.HashMap")) {
            abmap = new HashMap();
        } else if (java_class.equals("java.util.TreeMap")) {
            abmap = new TreeMap();
        } else if (java_class.equals("java.util.LinkedHashMap")) {
            abmap = new LinkedHashMap();
        } else {
            throw new UnmarshallException("not a Map");
        }
        try {
            jsonmap = jso.getJSONObject("map");
        }
        catch (JSONException e) {
            throw new UnmarshallException("Could not read map: " + e.getMessage(), e);
        }
        if (jsonmap == null) {
            throw new UnmarshallException("map missing");
        }
        state.setSerialized(o, abmap);
        Iterator i = jsonmap.keys();
        String key = null;
        try {
            while (i.hasNext()) {
                key = (String)i.next();
                abmap.put(key, this.ser.unmarshall(state, null, jsonmap.get(key)));
            }
        }
        catch (UnmarshallException e) {
            throw new UnmarshallException("key " + key + " " + e.getMessage(), e);
        }
        catch (JSONException e) {
            throw new UnmarshallException("key " + key + " " + e.getMessage(), e);
        }
        return abmap;
    }
}

