/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.analysis;

import java.util.Locale;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.KeywordTokenizer;
import org.apache.lucene.analysis.core.LetterTokenizer;
import org.apache.lucene.analysis.core.LowerCaseTokenizer;
import org.apache.lucene.analysis.core.WhitespaceTokenizer;
import org.apache.lucene.analysis.ngram.EdgeNGramTokenizer;
import org.apache.lucene.analysis.ngram.Lucene43EdgeNGramTokenizer;
import org.apache.lucene.analysis.ngram.Lucene43NGramTokenizer;
import org.apache.lucene.analysis.ngram.NGramTokenizer;
import org.apache.lucene.analysis.path.PathHierarchyTokenizer;
import org.apache.lucene.analysis.pattern.PatternTokenizer;
import org.apache.lucene.analysis.standard.ClassicTokenizer;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.analysis.standard.UAX29URLEmailTokenizer;
import org.apache.lucene.analysis.standard.std40.StandardTokenizer40;
import org.apache.lucene.analysis.standard.std40.UAX29URLEmailTokenizer40;
import org.apache.lucene.analysis.th.ThaiTokenizer;
import org.elasticsearch.Version;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.index.analysis.TokenizerFactory;
import org.elasticsearch.indices.analysis.PreBuiltCacheFactory;

public enum PreBuiltTokenizers {
    STANDARD(PreBuiltCacheFactory.CachingStrategy.LUCENE){

        @Override
        protected Tokenizer create(Version version) {
            if (version.luceneVersion.onOrAfter(org.apache.lucene.util.Version.LUCENE_4_7_0)) {
                return new StandardTokenizer();
            }
            return new StandardTokenizer40();
        }
    }
    ,
    CLASSIC(PreBuiltCacheFactory.CachingStrategy.LUCENE){

        @Override
        protected Tokenizer create(Version version) {
            return new ClassicTokenizer();
        }
    }
    ,
    UAX_URL_EMAIL(PreBuiltCacheFactory.CachingStrategy.LUCENE){

        @Override
        protected Tokenizer create(Version version) {
            if (version.luceneVersion.onOrAfter(org.apache.lucene.util.Version.LUCENE_4_7_0)) {
                return new UAX29URLEmailTokenizer();
            }
            return new UAX29URLEmailTokenizer40();
        }
    }
    ,
    PATH_HIERARCHY(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        protected Tokenizer create(Version version) {
            return new PathHierarchyTokenizer();
        }
    }
    ,
    KEYWORD(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        protected Tokenizer create(Version version) {
            return new KeywordTokenizer();
        }
    }
    ,
    LETTER(PreBuiltCacheFactory.CachingStrategy.LUCENE){

        @Override
        protected Tokenizer create(Version version) {
            return new LetterTokenizer();
        }
    }
    ,
    LOWERCASE(PreBuiltCacheFactory.CachingStrategy.LUCENE){

        @Override
        protected Tokenizer create(Version version) {
            return new LowerCaseTokenizer();
        }
    }
    ,
    WHITESPACE(PreBuiltCacheFactory.CachingStrategy.LUCENE){

        @Override
        protected Tokenizer create(Version version) {
            return new WhitespaceTokenizer();
        }
    }
    ,
    NGRAM(PreBuiltCacheFactory.CachingStrategy.LUCENE){

        @Override
        protected Tokenizer create(Version version) {
            if (version.onOrAfter(Version.V_0_90_2) && version.luceneVersion.onOrAfter(org.apache.lucene.util.Version.LUCENE_4_3)) {
                return new NGramTokenizer();
            }
            return new Lucene43NGramTokenizer();
        }
    }
    ,
    EDGE_NGRAM(PreBuiltCacheFactory.CachingStrategy.LUCENE){

        @Override
        protected Tokenizer create(Version version) {
            if (version.onOrAfter(Version.V_0_90_2) && version.luceneVersion.onOrAfter(org.apache.lucene.util.Version.LUCENE_4_3)) {
                return new EdgeNGramTokenizer(1, 1);
            }
            return new Lucene43EdgeNGramTokenizer(1, 1);
        }
    }
    ,
    PATTERN(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        protected Tokenizer create(Version version) {
            return new PatternTokenizer(Regex.compile("\\W+", null), -1);
        }
    }
    ,
    THAI(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        protected Tokenizer create(Version version) {
            return new ThaiTokenizer();
        }
    };

    protected final PreBuiltCacheFactory.PreBuiltCache<TokenizerFactory> cache;

    protected abstract Tokenizer create(Version var1);

    private PreBuiltTokenizers(PreBuiltCacheFactory.CachingStrategy cachingStrategy) {
        this.cache = PreBuiltCacheFactory.getCache(cachingStrategy);
    }

    public synchronized TokenizerFactory getTokenizerFactory(final Version version) {
        TokenizerFactory tokenizerFactory = this.cache.get(version);
        if (tokenizerFactory == null) {
            final String finalName = this.name();
            tokenizerFactory = new TokenizerFactory(){

                @Override
                public String name() {
                    return finalName.toLowerCase(Locale.ROOT);
                }

                @Override
                public Tokenizer create() {
                    return PreBuiltTokenizers.valueOf(finalName).create(version);
                }
            };
            this.cache.put(version, tokenizerFactory);
        }
        return tokenizerFactory;
    }

    public static PreBuiltTokenizers getOrDefault(String name, PreBuiltTokenizers defaultTokenizer) {
        try {
            return PreBuiltTokenizers.valueOf(name.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            return defaultTokenizer;
        }
    }
}

