/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class SimpleQueryParser
extends org.apache.lucene.queryparser.simple.SimpleQueryParser {
    private final Settings settings;

    public SimpleQueryParser(Analyzer analyzer, Map<String, Float> weights, int flags, Settings settings) {
        super(analyzer, weights, flags);
        this.settings = settings;
    }

    private Query rethrowUnlessLenient(RuntimeException e) {
        if (this.settings.lenient()) {
            return null;
        }
        throw e;
    }

    public Query newDefaultQuery(String text) {
        BooleanQuery.Builder bq = new BooleanQuery.Builder();
        bq.setDisableCoord(true);
        for (Map.Entry entry : this.weights.entrySet()) {
            try {
                Query q = this.createBooleanQuery((String)entry.getKey(), text, super.getDefaultOperator());
                if (q == null) continue;
                q.setBoost(((Float)entry.getValue()).floatValue());
                bq.add(q, BooleanClause.Occur.SHOULD);
            }
            catch (RuntimeException e) {
                this.rethrowUnlessLenient(e);
            }
        }
        return super.simplify(bq.build());
    }

    public Query newFuzzyQuery(String text, int fuzziness) {
        if (this.settings.lowercaseExpandedTerms()) {
            text = text.toLowerCase(this.settings.locale());
        }
        BooleanQuery.Builder bq = new BooleanQuery.Builder();
        bq.setDisableCoord(true);
        for (Map.Entry entry : this.weights.entrySet()) {
            try {
                FuzzyQuery q = new FuzzyQuery(new Term((String)entry.getKey(), text), fuzziness);
                q.setBoost(((Float)entry.getValue()).floatValue());
                bq.add((Query)q, BooleanClause.Occur.SHOULD);
            }
            catch (RuntimeException e) {
                this.rethrowUnlessLenient(e);
            }
        }
        return super.simplify(bq.build());
    }

    public Query newPhraseQuery(String text, int slop) {
        BooleanQuery.Builder bq = new BooleanQuery.Builder();
        bq.setDisableCoord(true);
        for (Map.Entry entry : this.weights.entrySet()) {
            try {
                Query q = this.createPhraseQuery((String)entry.getKey(), text, slop);
                if (q == null) continue;
                q.setBoost(((Float)entry.getValue()).floatValue());
                bq.add(q, BooleanClause.Occur.SHOULD);
            }
            catch (RuntimeException e) {
                this.rethrowUnlessLenient(e);
            }
        }
        return super.simplify(bq.build());
    }

    public Query newPrefixQuery(String text) {
        if (this.settings.lowercaseExpandedTerms()) {
            text = text.toLowerCase(this.settings.locale());
        }
        BooleanQuery.Builder bq = new BooleanQuery.Builder();
        bq.setDisableCoord(true);
        for (Map.Entry entry : this.weights.entrySet()) {
            try {
                if (this.settings.analyzeWildcard()) {
                    Query analyzedQuery = this.newPossiblyAnalyzedQuery((String)entry.getKey(), text);
                    if (analyzedQuery == null) continue;
                    analyzedQuery.setBoost(((Float)entry.getValue()).floatValue());
                    bq.add(analyzedQuery, BooleanClause.Occur.SHOULD);
                    continue;
                }
                PrefixQuery prefix = new PrefixQuery(new Term((String)entry.getKey(), text));
                prefix.setBoost(((Float)entry.getValue()).floatValue());
                bq.add((Query)prefix, BooleanClause.Occur.SHOULD);
            }
            catch (RuntimeException e) {
                return this.rethrowUnlessLenient(e);
            }
        }
        return super.simplify(bq.build());
    }

    private Query newPossiblyAnalyzedQuery(String field, String termStr) {
        ArrayList tlist = new ArrayList();
        try (TokenStream source = this.getAnalyzer().tokenStream(field, termStr);){
            source.reset();
            ArrayList<String> currentPos = new ArrayList<String>();
            CharTermAttribute termAtt = (CharTermAttribute)source.addAttribute(CharTermAttribute.class);
            PositionIncrementAttribute posAtt = (PositionIncrementAttribute)source.addAttribute(PositionIncrementAttribute.class);
            try {
                boolean hasMoreTokens = source.incrementToken();
                while (hasMoreTokens) {
                    if (!currentPos.isEmpty() && posAtt.getPositionIncrement() > 0) {
                        tlist.add(currentPos);
                        currentPos = new ArrayList();
                    }
                    currentPos.add(termAtt.toString());
                    hasMoreTokens = source.incrementToken();
                }
                if (!currentPos.isEmpty()) {
                    tlist.add(currentPos);
                }
            }
            catch (IOException hasMoreTokens) {
                // empty catch block
            }
        }
        catch (IOException e) {
            return new PrefixQuery(new Term(field, termStr));
        }
        if (tlist.size() == 0) {
            return null;
        }
        if (tlist.size() == 1 && ((List)tlist.get(0)).size() == 1) {
            return new PrefixQuery(new Term(field, (String)((List)tlist.get(0)).get(0)));
        }
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        for (int pos = 0; pos < tlist.size(); ++pos) {
            Object posQuery;
            boolean isLastPos;
            List plist = (List)tlist.get(pos);
            boolean bl = isLastPos = pos == tlist.size() - 1;
            if (plist.size() == 1) {
                posQuery = isLastPos ? new PrefixQuery(new Term(field, (String)plist.get(0))) : this.newTermQuery(new Term(field, (String)plist.get(0)));
            } else if (!isLastPos) {
                ArrayList<TermQuery> terms = new ArrayList<TermQuery>();
                for (int i = 0; i < plist.size(); ++i) {
                    terms.add(new TermQuery(new Term(field, (String)plist.get(i))));
                }
                posQuery = new DisjunctionMaxQuery(terms, 0.0f);
            } else {
                BooleanQuery.Builder innerBuilder = new BooleanQuery.Builder();
                for (String token : plist) {
                    innerBuilder.add(new BooleanClause((Query)new PrefixQuery(new Term(field, token)), BooleanClause.Occur.SHOULD));
                }
                posQuery = innerBuilder.setDisableCoord(true).build();
            }
            builder.add(new BooleanClause(posQuery, this.getDefaultOperator()));
        }
        return builder.build();
    }

    public static class Settings {
        private Locale locale = Locale.ROOT;
        private boolean lowercaseExpandedTerms = true;
        private boolean lenient = false;
        private boolean analyzeWildcard = false;

        public void locale(Locale locale) {
            this.locale = locale;
        }

        public Locale locale() {
            return this.locale;
        }

        public void lowercaseExpandedTerms(boolean lowercaseExpandedTerms) {
            this.lowercaseExpandedTerms = lowercaseExpandedTerms;
        }

        public boolean lowercaseExpandedTerms() {
            return this.lowercaseExpandedTerms;
        }

        public void lenient(boolean lenient) {
            this.lenient = lenient;
        }

        public boolean lenient() {
            return this.lenient;
        }

        public void analyzeWildcard(boolean analyzeWildcard) {
            this.analyzeWildcard = analyzeWildcard;
        }

        public boolean analyzeWildcard() {
            return this.analyzeWildcard;
        }
    }
}

