/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.gateway.LocalAllocateDangledIndices;
import org.elasticsearch.gateway.MetaStateService;

public class DanglingIndicesState
extends AbstractComponent {
    private final NodeEnvironment nodeEnv;
    private final MetaStateService metaStateService;
    private final LocalAllocateDangledIndices allocateDangledIndices;
    private final Map<String, IndexMetaData> danglingIndices = ConcurrentCollections.newConcurrentMap();

    @Inject
    public DanglingIndicesState(Settings settings, NodeEnvironment nodeEnv, MetaStateService metaStateService, LocalAllocateDangledIndices allocateDangledIndices) {
        super(settings);
        this.nodeEnv = nodeEnv;
        this.metaStateService = metaStateService;
        this.allocateDangledIndices = allocateDangledIndices;
    }

    public void processDanglingIndices(MetaData metaData) {
        if (!this.nodeEnv.hasNodeFile()) {
            return;
        }
        this.cleanupAllocatedDangledIndices(metaData);
        this.findNewAndAddDanglingIndices(metaData);
        this.allocateDanglingIndices();
    }

    Map<String, IndexMetaData> getDanglingIndices() {
        return ImmutableMap.copyOf(this.danglingIndices);
    }

    void cleanupAllocatedDangledIndices(MetaData metaData) {
        for (String danglingIndex : this.danglingIndices.keySet()) {
            if (!metaData.hasIndex(danglingIndex)) continue;
            this.logger.debug("[{}] no longer dangling (created), removing from dangling list", danglingIndex);
            this.danglingIndices.remove(danglingIndex);
        }
    }

    void findNewAndAddDanglingIndices(MetaData metaData) {
        this.danglingIndices.putAll(this.findNewDanglingIndices(metaData));
    }

    Map<String, IndexMetaData> findNewDanglingIndices(MetaData metaData) {
        Set<String> indices;
        try {
            indices = this.nodeEnv.findAllIndices();
        }
        catch (Throwable e) {
            this.logger.warn("failed to list dangling indices", e, new Object[0]);
            return ImmutableMap.of();
        }
        HashMap newIndices = Maps.newHashMap();
        for (String indexName : indices) {
            if (metaData.hasIndex(indexName) || this.danglingIndices.containsKey(indexName)) continue;
            try {
                IndexMetaData indexMetaData = this.metaStateService.loadIndexState(indexName);
                if (indexMetaData != null) {
                    this.logger.info("[{}] dangling index, exists on local file system, but not in cluster metadata, auto import to cluster state", indexName);
                    if (!indexMetaData.getIndex().equals(indexName)) {
                        this.logger.info("dangled index directory name is [{}], state name is [{}], renaming to directory name", indexName, indexMetaData.getIndex());
                        indexMetaData = IndexMetaData.builder(indexMetaData).index(indexName).build();
                    }
                    newIndices.put(indexName, indexMetaData);
                    continue;
                }
                this.logger.debug("[{}] dangling index directory detected, but no state found", indexName);
            }
            catch (Throwable t) {
                this.logger.warn("[{}] failed to load index state for detected dangled index", t, indexName);
            }
        }
        return newIndices;
    }

    private void allocateDanglingIndices() {
        if (this.danglingIndices.isEmpty()) {
            return;
        }
        try {
            this.allocateDangledIndices.allocateDangled(Collections.unmodifiableCollection(new ArrayList<IndexMetaData>(this.danglingIndices.values())), new LocalAllocateDangledIndices.Listener(){

                @Override
                public void onResponse(LocalAllocateDangledIndices.AllocateDangledResponse response) {
                    DanglingIndicesState.this.logger.trace("allocated dangled", new Object[0]);
                }

                @Override
                public void onFailure(Throwable e) {
                    DanglingIndicesState.this.logger.info("failed to send allocated dangled", e, new Object[0]);
                }
            });
        }
        catch (Throwable e) {
            this.logger.warn("failed to send allocate dangled", e, new Object[0]);
        }
    }
}

