/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search.function;

import java.util.Locale;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Explanation;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.lucene.search.function.CombineFunction;
import org.elasticsearch.common.lucene.search.function.LeafScoreFunction;
import org.elasticsearch.common.lucene.search.function.ScoreFunction;
import org.elasticsearch.index.fielddata.AtomicNumericFieldData;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;

public class FieldValueFactorFunction
extends ScoreFunction {
    private final String field;
    private final float boostFactor;
    private final Modifier modifier;
    private final Double missing;
    private final IndexNumericFieldData indexFieldData;

    public FieldValueFactorFunction(String field, float boostFactor, Modifier modifierType, Double missing, IndexNumericFieldData indexFieldData) {
        super(CombineFunction.MULT);
        this.field = field;
        this.boostFactor = boostFactor;
        this.modifier = modifierType;
        this.indexFieldData = indexFieldData;
        this.missing = missing;
    }

    @Override
    public LeafScoreFunction getLeafScoreFunction(LeafReaderContext ctx) {
        final SortedNumericDoubleValues values = this.indexFieldData == null ? FieldData.emptySortedNumericDoubles(ctx.reader().maxDoc()) : ((AtomicNumericFieldData)this.indexFieldData.load(ctx)).getDoubleValues();
        return new LeafScoreFunction(){

            @Override
            public double score(int docId, float subQueryScore) {
                double value;
                values.setDocument(docId);
                int numValues = values.count();
                if (numValues > 0) {
                    value = values.valueAt(0);
                } else if (FieldValueFactorFunction.this.missing != null) {
                    value = FieldValueFactorFunction.this.missing;
                } else {
                    throw new ElasticsearchException("Missing value for field [" + FieldValueFactorFunction.this.field + "]", new Object[0]);
                }
                double val = value * (double)FieldValueFactorFunction.this.boostFactor;
                double result = FieldValueFactorFunction.this.modifier.apply(val);
                if (Double.isNaN(result) || Double.isInfinite(result)) {
                    throw new ElasticsearchException("Result of field modification [" + FieldValueFactorFunction.this.modifier.toString() + "(" + val + ")] must be a number", new Object[0]);
                }
                return result;
            }

            @Override
            public Explanation explainScore(int docId, Explanation subQueryScore) {
                String modifierStr = FieldValueFactorFunction.this.modifier != null ? FieldValueFactorFunction.this.modifier.toString() : "";
                String defaultStr = FieldValueFactorFunction.this.missing != null ? "?:" + FieldValueFactorFunction.this.missing : "";
                double score = this.score(docId, subQueryScore.getValue());
                return Explanation.match((float)CombineFunction.toFloat(score), (String)String.format(Locale.ROOT, "field value function: %s(doc['%s'].value%s * factor=%s)", modifierStr, FieldValueFactorFunction.this.field, defaultStr, Float.valueOf(FieldValueFactorFunction.this.boostFactor)), (Explanation[])new Explanation[0]);
            }
        };
    }

    @Override
    public boolean needsScores() {
        return false;
    }

    public static enum Modifier {
        NONE{

            @Override
            public double apply(double n) {
                return n;
            }
        }
        ,
        LOG{

            @Override
            public double apply(double n) {
                return Math.log10(n);
            }
        }
        ,
        LOG1P{

            @Override
            public double apply(double n) {
                return Math.log10(n + 1.0);
            }
        }
        ,
        LOG2P{

            @Override
            public double apply(double n) {
                return Math.log10(n + 2.0);
            }
        }
        ,
        LN{

            @Override
            public double apply(double n) {
                return Math.log(n);
            }
        }
        ,
        LN1P{

            @Override
            public double apply(double n) {
                return Math.log1p(n);
            }
        }
        ,
        LN2P{

            @Override
            public double apply(double n) {
                return Math.log1p(n + 1.0);
            }
        }
        ,
        SQUARE{

            @Override
            public double apply(double n) {
                return Math.pow(n, 2.0);
            }
        }
        ,
        SQRT{

            @Override
            public double apply(double n) {
                return Math.sqrt(n);
            }
        }
        ,
        RECIPROCAL{

            @Override
            public double apply(double n) {
                return 1.0 / n;
            }
        };


        public abstract double apply(double var1);

        public String toString() {
            return super.toString().toLowerCase(Locale.ROOT);
        }
    }
}

