/*
 * Licensed to Elasticsearch under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.elasticsearch.index.analysis;

import org.apache.lucene.util.Version;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;

/**
 *
 */
public abstract class AbstractTokenizerFactory extends AbstractIndexComponent implements TokenizerFactory {

    private final String name;

    protected final Version version;


    public AbstractTokenizerFactory(Index index, Settings indexSettings, String name, Settings settings) {
        super(index, indexSettings);
        this.name = name;
        this.version = Analysis.parseAnalysisVersion(indexSettings, settings, logger);
    }

    @Override
    public String name() {
        return this.name;
    }
    
    public final Version version() {
        return version;
    }
}
