/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal.servlet;

import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.eclipse.equinox.http.servlet.internal.context.ContextController;
import org.eclipse.equinox.http.servlet.internal.servlet.HttpSessionAdaptor;
import org.eclipse.equinox.http.servlet.internal.util.EventListeners;

public class HttpSessionTracker {
    private static final ConcurrentMap<String, Set<HttpSessionAdaptor>> _httpSessionAdaptorsMap = new ConcurrentHashMap<String, Set<HttpSessionAdaptor>>();

    public static void clearHttpSessionAdaptors(String sessionId) {
        Set httpSessionAdaptors = (Set)_httpSessionAdaptorsMap.remove(sessionId);
        if (httpSessionAdaptors == null) {
            return;
        }
        for (HttpSessionAdaptor httpSessionAdaptor : httpSessionAdaptors) {
            ContextController contextController = httpSessionAdaptor.getController();
            EventListeners eventListeners = contextController.getEventListeners();
            List<HttpSessionListener> httpSessionListeners = eventListeners.get(HttpSessionListener.class);
            if (!httpSessionListeners.isEmpty()) {
                HttpSessionEvent httpSessionEvent = new HttpSessionEvent((HttpSession)httpSessionAdaptor);
                for (HttpSessionListener listener : httpSessionListeners) {
                    try {
                        listener.sessionDestroyed(httpSessionEvent);
                    }
                    catch (IllegalStateException illegalStateException) {}
                }
            }
            List<HttpSessionAttributeListener> httpSessionAttributeListeners = eventListeners.get(HttpSessionAttributeListener.class);
            if (!httpSessionListeners.isEmpty()) {
                Enumeration<String> enumeration = httpSessionAdaptor.getAttributeNames();
                while (enumeration.hasMoreElements()) {
                    HttpSessionBindingEvent httpSessionBindingEvent = new HttpSessionBindingEvent((HttpSession)httpSessionAdaptor, enumeration.nextElement());
                    for (HttpSessionAttributeListener httpSessionAttributeListener : httpSessionAttributeListeners) {
                        httpSessionAttributeListener.attributeRemoved(httpSessionBindingEvent);
                    }
                }
            }
            contextController.removeActiveSession(httpSessionAdaptor.getId());
        }
    }

    public static void addHttpSessionAdaptor(HttpSessionAdaptor httpSessionAdaptor) {
        Set previousHttpSessionAdaptors;
        String sessionId = httpSessionAdaptor.getId();
        Set httpSessionAdaptors = (Set)_httpSessionAdaptorsMap.get(sessionId);
        if (httpSessionAdaptors == null && (previousHttpSessionAdaptors = _httpSessionAdaptorsMap.putIfAbsent(sessionId, httpSessionAdaptors = Collections.newSetFromMap(new ConcurrentHashMap()))) != null) {
            httpSessionAdaptors = previousHttpSessionAdaptors;
        }
        httpSessionAdaptors.add(httpSessionAdaptor);
    }

    public static boolean removeHttpSessionAdaptor(HttpSessionAdaptor httpSessionAdaptor) {
        Set httpSessionAdaptors = (Set)_httpSessionAdaptorsMap.get(httpSessionAdaptor.getId());
        if (httpSessionAdaptors == null) {
            return false;
        }
        return httpSessionAdaptors.remove(httpSessionAdaptor);
    }
}

