/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.runtime.threadio;

import java.io.InputStream;
import java.io.PrintStream;
import java.util.Deque;
import java.util.LinkedList;
import org.apache.felix.gogo.runtime.threadio.Marker;
import org.apache.felix.gogo.runtime.threadio.ThreadInputStream;
import org.apache.felix.gogo.runtime.threadio.ThreadPrintStream;
import org.apache.felix.service.threadio.ThreadIO;

public class ThreadIOImpl
implements ThreadIO {
    final Marker defaultMarker = new Marker(System.in, System.out, System.err, null);
    final ThreadPrintStream err = new ThreadPrintStream(this, System.err, true);
    final ThreadPrintStream out = new ThreadPrintStream(this, System.out, false);
    final ThreadInputStream in = new ThreadInputStream(this, System.in);
    final ThreadLocal<Deque<Marker>> current = new InheritableThreadLocal<Deque<Marker>>(){

        @Override
        protected Deque<Marker> childValue(Deque<Marker> markers) {
            return new LinkedList<Marker>(markers);
        }

        @Override
        protected Deque<Marker> initialValue() {
            return new LinkedList<Marker>();
        }
    };

    public void start() {
    }

    public void stop() {
    }

    Marker current() {
        Marker marker;
        Deque<Marker> markers = this.current.get();
        while (true) {
            if ((marker = markers.peek()) == null) {
                this.current.remove();
                return this.defaultMarker;
            }
            if (!marker.deactivated) break;
            markers.pop();
        }
        return marker;
    }

    @Override
    public void close() {
        Deque<Marker> markers = this.current.get();
        Marker marker = markers.pop();
        marker.deactivate();
        if (markers.isEmpty()) {
            this.current.remove();
            System.setOut(this.defaultMarker.out);
            System.setIn(this.defaultMarker.in);
            System.setErr(this.defaultMarker.err);
        }
    }

    @Override
    public void setStreams(InputStream in, PrintStream out, PrintStream err) {
        assert (in != null);
        assert (out != null);
        assert (err != null);
        Deque<Marker> markers = this.current.get();
        Marker previousMarker = null;
        if (markers.isEmpty()) {
            previousMarker = this.defaultMarker;
            System.setErr(this.err);
            System.setIn(this.in);
            System.setOut(this.out);
        } else {
            previousMarker = markers.peek();
        }
        if (in == this.in) {
            in = previousMarker.in;
        }
        if (out == this.out) {
            out = previousMarker.out;
        }
        if (err == this.err) {
            err = previousMarker.err;
        }
        markers.push(new Marker(in, out, err, null));
    }
}

