/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.utils.properties;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.felix.utils.properties.InterpolationHelper;
import org.osgi.framework.BundleContext;

public class Properties
extends AbstractMap<String, String> {
    public static final String DEFAULT_ENCODING = "ISO-8859-1";
    private static final String _COMMENT_CHARS = "#!";
    private static final int _HEX_RADIX = 16;
    private static final String _LINE_SEPARATOR = System.getProperty("line.separator");
    private static final char[] _SEPARATORS = new char[]{'=', ':'};
    private static final int _UNICODE_LEN = 4;
    private static final char[] _WHITE_SPACE = new char[]{' ', '\t', '\f'};
    private InterpolationHelper.SubstitutionCallback _callback;
    private List<String> _footer;
    private List<String> _header;
    private final Map<String, Layout> _layoutMap = new LinkedHashMap<String, Layout>();
    private File _location;
    private final Map<String, String> _storage = new LinkedHashMap<String, String>();
    private boolean _substitute = true;
    private boolean _typed;

    public static boolean contains(char[] array, char valueToFind) {
        if (array == null) {
            return false;
        }
        for (int i = 0; i < array.length; ++i) {
            if (valueToFind != array[i]) continue;
            return true;
        }
        return false;
    }

    public Properties() {
    }

    public Properties(boolean substitute) {
        this._substitute = substitute;
    }

    public Properties(File location) throws IOException {
        this(location, (InterpolationHelper.SubstitutionCallback)null);
    }

    public Properties(File location, boolean substitute) {
        this._location = location;
        this._substitute = substitute;
    }

    public Properties(File location, BundleContext context) throws IOException {
        this(location, new InterpolationHelper.BundleContextSubstitutionCallback(context));
    }

    public Properties(File location, InterpolationHelper.SubstitutionCallback callback) throws IOException {
        this._location = location;
        this._callback = callback;
        if (location.exists()) {
            this.load(location);
        }
    }

    @Override
    public void clear() {
        for (Layout layout : this._layoutMap.values()) {
            layout.clearValue();
        }
        this._storage.clear();
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return new AbstractSet<Map.Entry<String, String>>(){

            @Override
            public Iterator<Map.Entry<String, String>> iterator() {
                return new KeyIterator();
            }

            @Override
            public int size() {
                return Properties.this._storage.size();
            }
        };
    }

    public List<String> getComments(String key) {
        List<String> commentLines;
        Layout layout = this._layoutMap.get(key);
        if (layout != null && (commentLines = layout.getCommentLines()) != null) {
            return new ArrayList<String>(commentLines);
        }
        return new ArrayList<String>();
    }

    public List<String> getFooter() {
        return this._footer;
    }

    public List<String> getHeader() {
        return this._header;
    }

    public String getProperty(String key) {
        return (String)this.get(key);
    }

    public String getProperty(String key, String defaultValue) {
        if (this.get(key) != null) {
            return (String)this.get(key);
        }
        return defaultValue;
    }

    public List<String> getRaw(String key) {
        List<String> valueLines;
        Layout layout = this._layoutMap.get(key);
        if (layout != null && (valueLines = layout.getValueLines()) != null) {
            return new ArrayList<String>(valueLines);
        }
        ArrayList<String> result = new ArrayList<String>();
        if (this._storage.containsKey(key)) {
            result.add(this._storage.get(key));
        }
        return result;
    }

    public boolean isTyped() {
        return this._typed;
    }

    public void load(File location) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(location);){
            this.load(inputStream);
        }
    }

    public void load(InputStream inputStream) throws IOException {
        this.load(new InputStreamReader(inputStream, DEFAULT_ENCODING));
    }

    public void load(Reader reader) throws IOException {
        this.loadLayout(reader, false);
    }

    public void load(URL url) throws IOException {
        try (InputStream inputStream = url.openStream();){
            this.load(inputStream);
        }
    }

    public void loadLayout(Reader reader, boolean maybeTyped) throws IOException {
        PropertiesReader propertiesReader = new PropertiesReader(reader, maybeTyped);
        boolean hasProperty = false;
        while (propertiesReader.nextProperty()) {
            hasProperty = true;
            this._storage.put(propertiesReader.getPropertyName(), propertiesReader.getPropertyValue());
            int index = this._checkHeaderComment(propertiesReader.getCommentLines());
            List<String> commentLines = propertiesReader.getCommentLines();
            int size = commentLines.size();
            commentLines = index < commentLines.size() ? commentLines.subList(index, size) : null;
            this._layoutMap.put(propertiesReader.getPropertyName(), new Layout(commentLines, new ArrayList<String>(propertiesReader.getValueLines())));
        }
        Boolean typed = propertiesReader.isTyped();
        if (!maybeTyped || typed == null || !typed.booleanValue()) {
            this._typed = false;
            for (Map.Entry<String, String> entry : this._storage.entrySet()) {
                entry.setValue(Properties._unescapeJava(entry.getValue()));
            }
        } else {
            this._typed = true;
        }
        if (hasProperty) {
            this._footer = new ArrayList<String>(propertiesReader.getCommentLines());
        } else {
            this._header = new ArrayList<String>(propertiesReader.getCommentLines());
        }
        if (this._substitute) {
            this.substitute();
        }
    }

    public Enumeration<?> propertyNames() {
        return Collections.enumeration(this._storage.keySet());
    }

    public String put(String key, List<String> commentLines, List<String> valueLines) {
        commentLines = new ArrayList<String>(commentLines);
        valueLines = new ArrayList<String>(valueLines);
        String escapedKey = Properties._escapeKey(key);
        StringBuilder sb = new StringBuilder();
        if (valueLines.isEmpty()) {
            valueLines.add(escapedKey + "=");
            sb.append(escapedKey);
            sb.append("=");
        } else {
            String value;
            String realValue = value = valueLines.get(0);
            if (!this._typed) {
                realValue = Properties._escapeJava(value);
            }
            if (!(value = value.trim()).startsWith(escapedKey)) {
                valueLines.set(0, escapedKey + " = " + realValue);
                sb.append(escapedKey);
                sb.append(" = ");
                sb.append(realValue);
            } else {
                valueLines.set(0, realValue);
                sb.append(realValue);
            }
        }
        for (int i = 1; i < valueLines.size(); ++i) {
            String value = valueLines.get(i);
            if (this._typed) {
                valueLines.set(i, value);
            } else {
                valueLines.set(i, Properties._escapeJava(value));
            }
            while (value.length() > 0 && Character.isWhitespace(value.charAt(0))) {
                value = value.substring(1);
            }
            sb.append(value);
        }
        String[] property = PropertiesReader._parseProperty(sb.toString());
        this._layoutMap.put(key, new Layout(commentLines, valueLines));
        return this._storage.put(key, property[1]);
    }

    public String put(String key, List<String> commentLines, String value) {
        commentLines = new ArrayList<String>(commentLines);
        this._layoutMap.put(key, new Layout(commentLines, null));
        return this._storage.put(key, value);
    }

    @Override
    public String put(String key, String value) {
        Layout layout;
        String old = this._storage.put(key, value);
        if (!(old != null && old.equals(value) || (layout = this._layoutMap.get(key)) == null)) {
            layout.clearValue();
        }
        return old;
    }

    public String put(String key, String comment, String value) {
        return this.put(key, Collections.singletonList(comment), value);
    }

    public void putAllSubstituted(Map<? extends String, ? extends String> map) {
        this._storage.putAll(map);
    }

    @Override
    public String remove(Object key) {
        Layout layout = this._layoutMap.get(key);
        if (layout != null) {
            layout.clearValue();
        }
        return this._storage.remove(key);
    }

    public void save() throws IOException {
        this.save(this._location);
    }

    public void save(File location) throws IOException {
        try (FileOutputStream outputStream = new FileOutputStream(location);){
            this.save(outputStream);
        }
    }

    public void save(OutputStream outputStream) throws IOException {
        this.save(new OutputStreamWriter(outputStream, DEFAULT_ENCODING));
    }

    public void save(Writer writer) throws IOException {
        this.saveLayout(writer, this._typed);
    }

    public void setFooter(List<String> footer) {
        this._footer = footer;
    }

    public void setHeader(List<String> header) {
        this._header = header;
    }

    public Object setProperty(String key, String value) {
        return this.put(key, value);
    }

    public void setTyped(boolean typed) {
        this._typed = typed;
    }

    public void store(OutputStream outputStream, String comment) throws IOException {
        this.save(outputStream);
    }

    public void substitute() {
        this.substitute(this._callback);
    }

    public void substitute(InterpolationHelper.SubstitutionCallback callback) {
        if (callback == null) {
            callback = new InterpolationHelper.BundleContextSubstitutionCallback(null);
        }
        InterpolationHelper.performSubstitution(this._storage, callback);
    }

    public boolean update(Map<String, String> props) {
        Properties properties = new Properties();
        if (props instanceof Properties) {
            properties = (Properties)props;
        } else {
            for (Map.Entry<String, String> e : props.entrySet()) {
                properties.put(e.getKey(), e.getValue());
            }
        }
        return this.update(properties);
    }

    public boolean update(Properties properties) {
        boolean modified = false;
        for (String key : new ArrayList(this.keySet())) {
            if (properties.containsKey(key)) continue;
            this.remove(key);
            modified = true;
        }
        for (String key : properties.keySet()) {
            String value = (String)this.get(key);
            List<String> comments = properties.getComments(key);
            List<String> rawValue = properties.getRaw(key);
            if (value == null) {
                this.put(key, comments, rawValue);
                modified = true;
                continue;
            }
            if (value.equals(properties.get(key))) continue;
            if (comments.isEmpty()) {
                comments = this.getComments(key);
            }
            this.put(key, comments, rawValue);
            modified = true;
        }
        return modified;
    }

    protected void saveLayout(Writer writer, boolean typed) throws IOException {
        try (PropertiesWriter propertiesWriter = new PropertiesWriter(writer, typed);){
            if (this._header != null) {
                for (String string : this._header) {
                    propertiesWriter.writeln(string);
                }
            }
            for (Map.Entry entry : this._storage.entrySet()) {
                List<String> valueLines;
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                Layout layout = this._layoutMap.get(key);
                if (layout == null) {
                    propertiesWriter.writeProperty(key, value);
                    continue;
                }
                List<String> commentLines = layout.getCommentLines();
                if (commentLines != null) {
                    for (String string : commentLines) {
                        propertiesWriter.writeln(string);
                    }
                }
                if ((valueLines = layout.getValueLines()) == null) {
                    propertiesWriter.writeProperty(key, value);
                    continue;
                }
                int size = valueLines.size();
                for (int i = 0; i < size; ++i) {
                    String string = valueLines.get(i);
                    if (i < size - 1) {
                        propertiesWriter.writeln(string + "\\");
                        continue;
                    }
                    propertiesWriter.writeln(string);
                }
            }
            if (this._footer != null) {
                for (String string : this._footer) {
                    propertiesWriter.writeln(string);
                }
            }
        }
    }

    private static String _escapeJava(String string) {
        if (string == null) {
            return null;
        }
        int length = string.length();
        StringBuffer stringBuffer = new StringBuffer(length * 2);
        for (int i = 0; i < length; ++i) {
            char c = string.charAt(i);
            if (c > '\u0fff') {
                stringBuffer.append("\\u");
                stringBuffer.append(Properties._hex(c));
                continue;
            }
            if (c > '\u00ff') {
                stringBuffer.append("\\u0");
                stringBuffer.append(Properties._hex(c));
                continue;
            }
            if (c > '\u007f') {
                stringBuffer.append("\\u00");
                stringBuffer.append(Properties._hex(c));
                continue;
            }
            if (c < ' ') {
                if (c == 'b') {
                    stringBuffer.append('\\');
                    stringBuffer.append('b');
                    continue;
                }
                if (c == 'n') {
                    stringBuffer.append('\\');
                    stringBuffer.append('n');
                    continue;
                }
                if (c == 't') {
                    stringBuffer.append('\\');
                    stringBuffer.append('t');
                    continue;
                }
                if (c == 'f') {
                    stringBuffer.append('\\');
                    stringBuffer.append('f');
                    continue;
                }
                if (c == 'r') {
                    stringBuffer.append('\\');
                    stringBuffer.append('r');
                    continue;
                }
                if (c > '\u000f') {
                    stringBuffer.append("\\u00");
                    stringBuffer.append(Properties._hex(c));
                    continue;
                }
                stringBuffer.append("\\u000");
                stringBuffer.append(Properties._hex(c));
                continue;
            }
            if (c == '\"') {
                stringBuffer.append('\\');
                stringBuffer.append('\"');
                continue;
            }
            if (c == '\\') {
                stringBuffer.append('\\');
                stringBuffer.append('\\');
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private static String _escapeKey(String key) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < key.length(); ++i) {
            char c = key.charAt(i);
            if (Properties.contains(_SEPARATORS, c) || Properties.contains(_WHITE_SPACE, c)) {
                stringBuffer.append('\\');
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private static String _hex(char ch) {
        String hexString = Integer.toHexString(ch);
        return hexString.toUpperCase(Locale.ENGLISH);
    }

    private static boolean _isCommentLine(String line) {
        String string = line.trim();
        return string.length() < 1 || _COMMENT_CHARS.indexOf(string.charAt(0)) >= 0;
    }

    private static String _unescapeJava(String string) {
        if (string == null) {
            return null;
        }
        int size = string.length();
        StringBuffer stringBuffer = new StringBuffer(size);
        StringBuffer unicode = new StringBuffer(4);
        boolean hadSlash = false;
        boolean inUnicode = false;
        for (int i = 0; i < size; ++i) {
            char c = string.charAt(i);
            if (inUnicode) {
                unicode.append(c);
                if (unicode.length() != 4) continue;
                try {
                    int value = Integer.parseInt(unicode.toString(), 16);
                    stringBuffer.append((char)value);
                    unicode.setLength(0);
                    inUnicode = false;
                    hadSlash = false;
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("Unable to parse unicode value: " + unicode, numberFormatException);
                }
            }
            if (hadSlash) {
                hadSlash = false;
                if (c == '\\') {
                    stringBuffer.append("\\");
                    continue;
                }
                if (c == '\'') {
                    stringBuffer.append('\'');
                    continue;
                }
                if (c == '\"') {
                    stringBuffer.append('\"');
                    continue;
                }
                if (c == 'r') {
                    stringBuffer.append('\r');
                    continue;
                }
                if (c == 'f') {
                    stringBuffer.append('\f');
                    continue;
                }
                if (c == 't') {
                    stringBuffer.append('\t');
                    continue;
                }
                if (c == 'n') {
                    stringBuffer.append('\n');
                    continue;
                }
                if (c == 'b') {
                    stringBuffer.append('\b');
                    continue;
                }
                if (c == 'u') {
                    inUnicode = true;
                    continue;
                }
                stringBuffer.append(c);
                continue;
            }
            if (c == '\\') {
                hadSlash = true;
                continue;
            }
            stringBuffer.append(c);
        }
        if (hadSlash) {
            stringBuffer.append('\\');
        }
        return stringBuffer.toString();
    }

    private int _checkHeaderComment(List<String> commentLines) {
        if (this.getHeader() == null && this._layoutMap.isEmpty()) {
            String commentLine;
            int index;
            for (index = commentLines.size() - 1; index >= 0 && (commentLine = commentLines.get(index)).length() > 0; --index) {
            }
            this.setHeader(new ArrayList<String>(commentLines.subList(0, index + 1)));
            return index + 1;
        }
        return 0;
    }

    private class KeyIterator
    implements Iterator {
        private final Iterator<Map.Entry<String, String>> _iterator;

        public KeyIterator() {
            Set entries = Properties.this._storage.entrySet();
            this._iterator = entries.iterator();
        }

        @Override
        public boolean hasNext() {
            return this._iterator.hasNext();
        }

        public Map.Entry<String, String> next() {
            final Map.Entry<String, String> entry = this._iterator.next();
            return new Map.Entry<String, String>(){

                @Override
                public String getKey() {
                    return (String)entry.getKey();
                }

                @Override
                public String getValue() {
                    return (String)entry.getValue();
                }

                @Override
                public String setValue(String value) {
                    Layout layout;
                    String old = entry.setValue(value);
                    if (!(old != null && old.equals(value) || (layout = (Layout)Properties.this._layoutMap.get(entry.getKey())) == null)) {
                        layout.clearValue();
                    }
                    return old;
                }
            };
        }

        @Override
        public void remove() {
            this._iterator.remove();
        }
    }

    private static class Layout {
        private List<String> _commentLines;
        private List<String> _valueLines;

        public Layout() {
        }

        public Layout(List<String> commentLines, List<String> valueLines) {
            this._commentLines = commentLines;
            this._valueLines = valueLines;
        }

        public void clearValue() {
            this._valueLines = null;
        }

        public List<String> getCommentLines() {
            return this._commentLines;
        }

        public List<String> getValueLines() {
            return this._valueLines;
        }

        public void setCommentLines(List<String> commentLines) {
            this._commentLines = commentLines;
        }

        public void setValueLines(List<String> valueLines) {
            this._valueLines = valueLines;
        }
    }

    public static class PropertiesWriter
    extends FilterWriter {
        private boolean _typed;

        public PropertiesWriter(Writer writer, boolean typed) {
            super(writer);
            this._typed = typed;
        }

        public void writeln(String string) throws IOException {
            if (string != null) {
                this.write(string);
            }
            this.write(_LINE_SEPARATOR);
        }

        public void writeProperty(String key, String value) throws IOException {
            this.write(Properties._escapeKey(key));
            this.write(" = ");
            this.write(this._typed ? value : Properties._escapeJava(value));
            this.writeln(null);
        }
    }

    public static class PropertiesReader
    extends LineNumberReader {
        private final List<String> _commentLines = new ArrayList<String>();
        private final boolean _maybeTyped;
        private Pattern _pattern = Pattern.compile("\\s*[TILFDXSCBilfdxscb]?(\\[[\\S\\s]*\\]|\\{[\\S\\s]*\\}|\"[\\S\\s]*\")\\s*");
        private String _propertyName;
        private String _propertyValue;
        private Boolean _typed;
        private final List<String> _valueLines = new ArrayList<String>();

        public PropertiesReader(Reader reader, boolean maybeTyped) {
            super(reader);
            this._maybeTyped = maybeTyped;
        }

        public List<String> getCommentLines() {
            return this._commentLines;
        }

        public String getPropertyName() {
            return this._propertyName;
        }

        public String getPropertyValue() {
            return this._propertyValue;
        }

        public List<String> getValueLines() {
            return this._valueLines;
        }

        public Boolean isTyped() {
            return this._typed;
        }

        public boolean nextProperty() throws IOException {
            String line = this.readProperty();
            if (line == null) {
                return false;
            }
            String[] property = PropertiesReader._parseProperty(line);
            boolean typed = false;
            if (this._maybeTyped && property[1].length() >= 2) {
                Matcher matcher = this._pattern.matcher(property[1]);
                typed = matcher.matches();
            }
            this._typed = this._typed == null ? Boolean.valueOf(typed) : Boolean.valueOf(this._typed & typed);
            this._propertyName = Properties._unescapeJava(property[0]);
            this._propertyValue = property[1];
            return true;
        }

        public String readProperty() throws IOException {
            this._commentLines.clear();
            this._valueLines.clear();
            StringBuffer buffer = new StringBuffer();
            while (true) {
                String line;
                if ((line = this.readLine()) == null) {
                    return null;
                }
                if (Properties._isCommentLine(line)) {
                    this._commentLines.add(line);
                    continue;
                }
                boolean combine = PropertiesReader._checkCombineLines(line);
                if (combine) {
                    line = line.substring(0, line.length() - 1);
                }
                this._valueLines.add(line);
                while (line.length() > 0 && Properties.contains(_WHITE_SPACE, line.charAt(0))) {
                    line = line.substring(1);
                }
                buffer.append(line);
                if (!combine) break;
            }
            return buffer.toString();
        }

        private static boolean _checkCombineLines(String line) {
            int bsCount = 0;
            for (int i = line.length() - 1; i >= 0 && line.charAt(i) == '\\'; --i) {
                ++bsCount;
            }
            return bsCount % 2 != 0;
        }

        private static String[] _parseProperty(String line) {
            String[] result = new String[2];
            StringBuffer key = new StringBuffer();
            StringBuffer value = new StringBuffer();
            int state = 0;
            for (int pos = 0; pos < line.length(); ++pos) {
                char c = line.charAt(pos);
                if (state == 0) {
                    if (c == '\\') {
                        state = 1;
                        continue;
                    }
                    if (Properties.contains(_WHITE_SPACE, c)) {
                        state = 2;
                        continue;
                    }
                    if (Properties.contains(_SEPARATORS, c)) {
                        state = 3;
                        continue;
                    }
                    key.append(c);
                    continue;
                }
                if (state == 1) {
                    if (Properties.contains(_SEPARATORS, c) || Properties.contains(_WHITE_SPACE, c)) {
                        key.append(c);
                    } else {
                        key.append('\\');
                        key.append(c);
                    }
                    state = 0;
                    continue;
                }
                if (state == 2) {
                    if (Properties.contains(_WHITE_SPACE, c)) {
                        state = 2;
                        continue;
                    }
                    if (Properties.contains(_SEPARATORS, c)) {
                        state = 3;
                        continue;
                    }
                    value.append(c);
                    state = 4;
                    continue;
                }
                if (state == 3) {
                    if (Properties.contains(_WHITE_SPACE, c)) {
                        state = 3;
                        continue;
                    }
                    value.append(c);
                    state = 4;
                    continue;
                }
                if (state != 4) continue;
                value.append(c);
            }
            result[0] = key.toString();
            result[1] = value.toString();
            return result;
        }
    }
}

