/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.fileinstall.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.felix.fileinstall.internal.Util;
import org.osgi.service.url.AbstractURLStreamHandlerService;

public class JarDirUrlHandler
extends AbstractURLStreamHandlerService {
    public static final String PROTOCOL = "jardir";
    private static final String _SYNTAX = "jardir: file";

    public URLConnection openConnection(URL url) throws IOException {
        String path = url.getPath();
        if (path == null) {
            throw new MalformedURLException("Path can not be null. Syntax: jardir: file");
        }
        if ((path = path.trim()).length() == 0) {
            throw new MalformedURLException("Path can not be empty. Syntax: jardir: file");
        }
        return new Connection(url);
    }

    public class Connection
    extends URLConnection {
        public Connection(URL url) {
            super(url);
        }

        @Override
        public void connect() throws IOException {
        }

        @Override
        public InputStream getInputStream() throws IOException {
            try {
                final PipedOutputStream pipedOutputStream = new PipedOutputStream();
                PipedInputStream inputStream = new PipedInputStream(pipedOutputStream);
                Thread thread = new Thread(){

                    @Override
                    public void run() {
                        URL url = Connection.this.getURL();
                        try {
                            Util.jarDir(new File(url.getPath()), pipedOutputStream);
                        }
                        catch (IOException ioException1) {
                            try {
                                pipedOutputStream.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }
                };
                thread.start();
                return inputStream;
            }
            catch (Exception exception) {
                throw new IOException("Error opening spring xml url", exception);
            }
        }
    }
}

