/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.configurator.impl.model;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.felix.configurator.impl.model.AbstractState;
import org.apache.felix.configurator.impl.model.Config;
import org.apache.felix.configurator.impl.model.ConfigList;

public class State
extends AbstractState
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int VERSION = 1;
    public static final String FILE_NAME = "state.ser";
    private Map<Long, Long> bundlesLastModified = new ConcurrentHashMap<Long, Long>();
    private Map<Long, Long> bundlesConfigAdminBundleId = new ConcurrentHashMap<Long, Long>();
    private volatile Set<String> initialHashes;

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(1);
        out.writeObject(this.bundlesLastModified);
        out.writeObject(this.bundlesConfigAdminBundleId);
        out.writeObject(this.initialHashes);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        if (version < 1 || version > 1) {
            throw new ClassNotFoundException(this.getClass().getName());
        }
        this.bundlesLastModified = (Map)in.readObject();
        this.bundlesConfigAdminBundleId = (Map)in.readObject();
        this.initialHashes = (Set)in.readObject();
    }

    public static State createOrReadState(File f) throws ClassNotFoundException, IOException {
        if (f == null || !f.exists()) {
            return new State();
        }
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(f, "r");){
            byte[] bytes = new byte[(int)randomAccessFile.length()];
            randomAccessFile.readFully(bytes);
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bytes));
            State state = (State)ois.readObject();
            return state;
        }
    }

    public static void writeState(File f, State state) throws IOException {
        if (f == null) {
            return;
        }
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(f, "rw");){
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(byteArrayOutputStream);
            oos.writeObject(state);
            oos.close();
            randomAccessFile.write(byteArrayOutputStream.toByteArray());
        }
    }

    public Long getLastModified(long bundleId) {
        return this.bundlesLastModified.get(bundleId);
    }

    public void setLastModified(long bundleId, long lastModified) {
        this.bundlesLastModified.put(bundleId, lastModified);
    }

    public void removeLastModified(long bundleId) {
        this.bundlesLastModified.remove(bundleId);
    }

    public Long getConfigAdminBundleId(long bundleId) {
        return this.bundlesConfigAdminBundleId.get(bundleId);
    }

    public void setConfigAdminBundleId(long bundleId, long lastModified) {
        this.bundlesConfigAdminBundleId.put(bundleId, lastModified);
    }

    public void removeConfigAdminBundleId(long bundleId) {
        this.bundlesConfigAdminBundleId.remove(bundleId);
    }

    public Set<Long> getKnownBundleIds() {
        return this.bundlesLastModified.keySet();
    }

    public Set<String> getInitialHashes() {
        return this.initialHashes;
    }

    public void setInitialHashes(Set<String> value) {
        this.initialHashes = value;
    }

    public void addAll(String pid, ConfigList configs) {
        if (configs != null) {
            ConfigList list = this.getConfigurations().get(pid);
            if (list == null) {
                list = new ConfigList();
                this.getConfigurations().put(pid, list);
            }
            list.addAll(configs);
        }
    }

    public void checkEnvironments(long bundleId) {
        block0: for (String pid : this.getPids()) {
            ConfigList configList = this.getConfigurations(pid);
            for (Config cfg : configList) {
                if (cfg.getBundleId() != bundleId) continue;
                configList.setHasChanges(true);
                continue block0;
            }
        }
    }

    public String toString() {
        return "State [bundlesLastModified=" + String.valueOf(this.bundlesLastModified) + ", initialHashes=" + String.valueOf(this.initialHashes) + ", bundlesConfigAdminBundleId=" + String.valueOf(this.bundlesConfigAdminBundleId) + "]";
    }

    public Set<Long> getBundleIdsUsingConfigAdmin() {
        return new HashSet<Long>(this.bundlesConfigAdminBundleId.keySet());
    }
}

