/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.cdi.extension.spi.adapt;

import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import java.util.Arrays;
import org.apache.aries.cdi.extension.spi.adapt.ProcessPotentialService;

public class MergeServiceTypes {
    private final Class<?>[] types;
    private final ProcessAnnotatedType<?> processAnnotatedType;

    private MergeServiceTypes(ProcessAnnotatedType<?> processAnnotatedType, Class<?> ... types) {
        this.types = types;
        this.processAnnotatedType = processAnnotatedType;
    }

    public Class<?>[] getTypes() {
        return this.types;
    }

    public ProcessAnnotatedType<?> getProcessAnnotatedType() {
        return this.processAnnotatedType;
    }

    public String toString() {
        return "MergeServiceTypes{types=" + Arrays.toString(this.types) + '}';
    }

    public static Builder forEvent(ProcessAnnotatedType<?> pat) {
        return new Builder(pat);
    }

    public static Builder forEvent(ProcessPotentialService pat) {
        return new Builder(pat.getProcessAnnotatedType());
    }

    public static final class Builder {
        private final ProcessAnnotatedType<?> processAnnotatedType;
        private Class<?>[] types;

        private Builder(ProcessAnnotatedType<?> processAnnotatedType) {
            if (processAnnotatedType == null) {
                throw new IllegalArgumentException("processAnnotatedType can't be null");
            }
            this.processAnnotatedType = processAnnotatedType;
        }

        public Builder withTypes(Class<?> ... types) {
            this.types = types;
            return this;
        }

        public MergeServiceTypes build() {
            if (this.types == null) {
                throw new IllegalArgumentException("No types set");
            }
            return new MergeServiceTypes((ProcessAnnotatedType)this.processAnnotatedType, (Class[])this.types);
        }
    }
}

