/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.cdi.container.internal.model;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.aries.cdi.container.internal.bean.ComponentPropertiesBean;
import org.apache.aries.cdi.container.internal.bean.ReferenceBean;
import org.apache.aries.cdi.container.internal.container.ContainerState;
import org.apache.aries.cdi.container.internal.model.ExtendedConfigurationTemplateDTO;
import org.apache.aries.cdi.container.internal.model.ExtendedReferenceTemplateDTO;
import org.apache.aries.cdi.container.internal.util.Logs;
import org.apache.aries.cdi.container.internal.util.Syncro;
import org.osgi.service.cdi.runtime.dto.template.ComponentTemplateDTO;
import org.osgi.service.cdi.runtime.dto.template.ConfigurationTemplateDTO;
import org.osgi.service.cdi.runtime.dto.template.ReferenceTemplateDTO;

public class OSGiBean
implements Comparable<OSGiBean> {
    private final Syncro _lock = new Syncro(true);
    private final Logs _logs;
    private final Class<?> _beanClass;
    private final List<ConfigurationTemplateDTO> _configurationsQueue = new CopyOnWriteArrayList<ConfigurationTemplateDTO>();
    private final List<ReferenceTemplateDTO> _referencesQueue = new CopyOnWriteArrayList<ReferenceTemplateDTO>();
    private volatile ComponentTemplateDTO _componentTemplate;
    private final AtomicBoolean _found = new AtomicBoolean();
    private volatile String _string;

    private OSGiBean(Logs logs, Class<?> beanClass) {
        this._logs = logs;
        this._beanClass = beanClass;
    }

    public synchronized void addConfiguration(ContainerState containerState, ConfigurationTemplateDTO dto) {
        try (Syncro syncro = this._lock.open();){
            if (this._componentTemplate == null) {
                this._configurationsQueue.add(dto);
            } else {
                ((ExtendedConfigurationTemplateDTO)dto).bean = new ComponentPropertiesBean(containerState, this._componentTemplate, (ExtendedConfigurationTemplateDTO)dto);
                this._componentTemplate.configurations.add(dto);
            }
        }
    }

    public synchronized void addReference(ReferenceTemplateDTO dto) {
        try (Syncro syncro = this._lock.open();){
            if (this._componentTemplate == null) {
                this._referencesQueue.add(dto);
            } else {
                ((ExtendedReferenceTemplateDTO)dto).bean = new ReferenceBean(this._logs, this._componentTemplate, (ExtendedReferenceTemplateDTO)dto);
                this._componentTemplate.references.add(dto);
            }
        }
    }

    @Override
    public int compareTo(OSGiBean other) {
        return this._beanClass.getName().compareTo(other._beanClass.getName());
    }

    public boolean found() {
        return this._found.get();
    }

    public void found(boolean found) {
        this._found.set(found);
    }

    public Class<?> getBeanClass() {
        return this._beanClass;
    }

    public synchronized ComponentTemplateDTO geComponentTemplateDTO() {
        try (Syncro syncro = this._lock.open();){
            ComponentTemplateDTO componentTemplateDTO = this._componentTemplate;
            return componentTemplateDTO;
        }
    }

    public ComponentTemplateDTO getComponent() {
        return this._componentTemplate;
    }

    public void setComponent(ContainerState containerState, ComponentTemplateDTO componentTemplate) {
        try (Syncro syncro = this._lock.open();){
            if (this._componentTemplate != null) {
                return;
            }
            this._componentTemplate = componentTemplate;
            this._configurationsQueue.removeIf(dto -> {
                ((ExtendedConfigurationTemplateDTO)dto).bean = new ComponentPropertiesBean(containerState, this._componentTemplate, (ExtendedConfigurationTemplateDTO)((Object)dto));
                this._componentTemplate.configurations.add(dto);
                return true;
            });
            this._referencesQueue.removeIf(dto -> {
                ((ExtendedReferenceTemplateDTO)dto).bean = new ReferenceBean(this._logs, this._componentTemplate, (ExtendedReferenceTemplateDTO)((Object)dto));
                this._componentTemplate.references.add(dto);
                return true;
            });
        }
    }

    public String toString() {
        if (this._string == null) {
            this._string = String.format("OSGiBean[%s]", this._beanClass.getName());
        }
        return this._string;
    }

    public static class Builder {
        private final Class<?> _beanClass;
        private final Logs _logs;

        public Builder(Logs logs, Class<?> beanClass) {
            this._logs = logs;
            this._beanClass = Objects.requireNonNull(beanClass);
        }

        public OSGiBean build() {
            return new OSGiBean(this._logs, this._beanClass);
        }
    }
}

