/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.cdi.container.internal.model;

import java.lang.annotation.Annotation;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.enterprise.context.BeforeDestroyed;
import javax.enterprise.context.Destroyed;
import javax.enterprise.context.Initialized;
import javax.enterprise.event.Event;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.apache.aries.cdi.container.internal.container.ComponentContext;
import org.apache.aries.cdi.container.internal.container.ContainerState;
import org.apache.aries.cdi.container.internal.container.Op;
import org.apache.aries.cdi.container.internal.container.Phase;
import org.apache.aries.cdi.container.internal.model.ExtendedActivationDTO;
import org.apache.aries.cdi.container.internal.model.ExtendedActivationTemplateDTO;
import org.apache.aries.cdi.container.internal.model.ExtendedComponentInstanceDTO;
import org.apache.aries.cdi.container.internal.util.Sets;
import org.apache.aries.cdi.container.internal.util.Throw;
import org.osgi.service.cdi.annotations.ComponentScoped;
import org.osgi.service.log.Logger;

public abstract class InstanceActivator
extends Phase {
    private final Logger _log;
    protected final ExtendedComponentInstanceDTO _instance;

    protected InstanceActivator(Builder<?> builder) {
        super(builder._containerState, builder._next);
        this._instance = builder._instance;
        this._log = builder._containerState.ccrLogs().getLogger(InstanceActivator.class);
    }

    @Override
    public abstract Op closeOp();

    @Override
    public abstract Op openOp();

    protected Map.Entry<ExtendedActivationDTO, Object> activate(Bean<? extends Object> bean, ExtendedActivationTemplateDTO activationTemplate, BeanManager beanManager) {
        ExtendedActivationDTO activationDTO = new ExtendedActivationDTO();
        activationDTO.errors = new CopyOnWriteArrayList();
        activationDTO.template = activationTemplate;
        activationDTO.instance = this._instance;
        this._instance.activations.add(activationDTO);
        ComponentContext.With with = new ComponentContext.With(activationDTO);
        try {
            Object object = this.containerState.componentContext().get(bean, beanManager.createCreationalContext(bean));
            Set qualifiers = bean.getQualifiers();
            Event event1 = beanManager.getEvent();
            event1 = event1.select(Sets.hashSet(qualifiers, new Annotation[]{Initialized.Literal.of(ComponentScoped.class)}).toArray(new Annotation[0]));
            try {
                event1.fire(object);
            }
            catch (Throwable t) {
                this._log.error(l -> l.error("CCR Error in activator event @Initialized for {} on {}", new Object[]{this._instance, this.bundle(), t}));
                activationDTO.errors.add(Throw.asString(t));
            }
            activationDTO.onClose = a -> {
                try (ComponentContext.With with2 = new ComponentContext.With((ExtendedActivationDTO)((Object)a));){
                    Event event2 = beanManager.getEvent();
                    event2 = event2.select(Sets.hashSet(qualifiers, new Annotation[]{BeforeDestroyed.Literal.of(ComponentScoped.class)}).toArray(new Annotation[0]));
                    try {
                        event2.fire(object);
                    }
                    catch (Throwable t) {
                        this._log.error(l -> l.error("CCR Error in activator event @BeforeDestroyed for {} on {}", new Object[]{this._instance, this.bundle(), t}));
                        activationDTO.errors.add(Throw.asString(t));
                    }
                    this.containerState.componentContext().destroy();
                    Event event3 = beanManager.getEvent();
                    event3 = event3.select(Sets.hashSet(qualifiers, new Annotation[]{Destroyed.Literal.of(ComponentScoped.class)}).toArray(new Annotation[0]));
                    try {
                        event3.fire(object);
                    }
                    catch (Throwable t) {
                        this._log.error(l -> l.error("CCR Error in activator event @Destroyed for {} on {}", new Object[]{this._instance, this.bundle(), t}));
                        activationDTO.errors.add(Throw.asString(t));
                    }
                    this._instance.activations.remove(a);
                }
            };
            AbstractMap.SimpleImmutableEntry<ExtendedActivationDTO, Object> simpleImmutableEntry = new AbstractMap.SimpleImmutableEntry<ExtendedActivationDTO, Object>(activationDTO, object);
            with.close();
            return simpleImmutableEntry;
        }
        catch (Throwable t) {
            try {
                this._log.error(l -> l.error("CCR Error in activator create for {} on {}", new Object[]{this._instance, this.bundle(), t}));
                activationDTO.errors.add(Throw.asString(t));
                AbstractMap.SimpleImmutableEntry<ExtendedActivationDTO, Object> simpleImmutableEntry = new AbstractMap.SimpleImmutableEntry<ExtendedActivationDTO, Object>(activationDTO, null);
                return simpleImmutableEntry;
            }
            finally {
                with.close();
            }
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        private ContainerState _containerState;
        protected ExtendedComponentInstanceDTO _instance;
        private Phase _next;

        public Builder(ContainerState containerState, Phase next) {
            this._containerState = containerState;
            this._next = next;
        }

        public abstract InstanceActivator build();

        public T setInstance(ExtendedComponentInstanceDTO instance) {
            this._instance = instance;
            return (T)this;
        }
    }
}

