/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.cdi.container.internal.model;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.aries.cdi.container.internal.container.ContainerState;
import org.apache.aries.cdi.container.internal.model.Binder;
import org.apache.aries.cdi.container.internal.util.Maps;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cdi.reference.BindService;
import org.osgi.service.log.Logger;

public class BindServiceImpl<T>
implements Binder<T>,
BindService<T> {
    private final ContainerState _containerState;
    private final Logger _log;
    private final List<ServiceReference<T>> _queue = new CopyOnWriteArrayList<ServiceReference<T>>();
    private final AtomicBoolean _enqueue = new AtomicBoolean(true);
    private volatile Optional<Consumer<T>> onAdding = Optional.empty();
    private volatile Optional<BiConsumer<T, Map<String, Object>>> onAddingBi = Optional.empty();
    private volatile Optional<Consumer<T>> onUpdate = Optional.empty();
    private volatile Optional<BiConsumer<T, Map<String, Object>>> onUpdateBi = Optional.empty();
    private volatile Optional<Consumer<T>> onRemove = Optional.empty();
    private volatile Optional<BiConsumer<T, Map<String, Object>>> onRemoveBi = Optional.empty();
    private volatile T service;

    public BindServiceImpl(ContainerState containerState) {
        this._containerState = containerState;
        this._log = this._containerState.containerLogs().getLogger(this.getClass());
    }

    @Override
    public BindServiceImpl<T> addingService(ServiceReference<T> reference) {
        if (this._enqueue.get()) {
            this._queue.add(reference);
            return this;
        }
        BundleContext bundleContext = this._containerState.bundleContext();
        this.service = bundleContext.getService(reference);
        Map<String, Object> map = Maps.of(reference.getProperties());
        this.onAdding.ifPresent(c -> {
            try {
                c.accept(this.service);
            }
            catch (Throwable t) {
                this._log.error(l -> l.error("CCR error in {}", (Object)this, (Object)t));
            }
        });
        this.onAddingBi.ifPresent(c -> {
            try {
                c.accept(this.service, map);
            }
            catch (Throwable t) {
                this._log.error(l -> l.error("CCR error in {}", (Object)this, (Object)t));
            }
        });
        return this;
    }

    @Override
    public BindServiceImpl<T> modifiedService(ServiceReference<T> reference) {
        if (this._enqueue.get()) {
            return this;
        }
        Map<String, Object> map = Maps.of(reference.getProperties());
        this.onUpdate.ifPresent(c -> {
            try {
                c.accept(this.service);
            }
            catch (Throwable t) {
                this._log.error(l -> l.error("CCR error in {}", (Object)this, (Object)t));
            }
        });
        this.onUpdateBi.ifPresent(c -> {
            try {
                c.accept(this.service, map);
            }
            catch (Throwable t) {
                this._log.error(l -> l.error("CCR error in {}", (Object)this, (Object)t));
            }
        });
        return this;
    }

    @Override
    public BindServiceImpl<T> removedService(ServiceReference<T> reference) {
        if (this._enqueue.get()) {
            this._queue.remove(reference);
            return this;
        }
        Map<String, Object> map = Maps.of(reference.getProperties());
        this.onRemove.ifPresent(c -> {
            try {
                c.accept(this.service);
            }
            catch (Throwable t) {
                this._log.error(l -> l.error("CCR error in {}", (Object)this, (Object)t));
            }
        });
        this.onRemoveBi.ifPresent(c -> {
            try {
                c.accept(this.service, map);
            }
            catch (Throwable t) {
                this._log.error(l -> l.error("CCR error in {}", (Object)this, (Object)t));
            }
        });
        return this;
    }

    public void bind() {
        this._enqueue.set(false);
        this._queue.removeIf(reference -> {
            this.addingService((ServiceReference)reference);
            return true;
        });
    }

    public BindServiceImpl<T> adding(Consumer<T> action) {
        this.onAdding = Optional.ofNullable(action);
        return this;
    }

    public BindServiceImpl<T> adding(BiConsumer<T, Map<String, Object>> action) {
        this.onAddingBi = Optional.ofNullable(action);
        return this;
    }

    public BindServiceImpl<T> modified(Consumer<T> consumer) {
        this.onUpdate = Optional.ofNullable(consumer);
        return this;
    }

    public BindServiceImpl<T> modified(BiConsumer<T, Map<String, Object>> consumer) {
        this.onUpdateBi = Optional.ofNullable(consumer);
        return this;
    }

    public BindServiceImpl<T> removed(Consumer<T> consumer) {
        this.onRemove = Optional.ofNullable(consumer);
        return this;
    }

    public BindServiceImpl<T> removed(BiConsumer<T, Map<String, Object>> consumer) {
        this.onRemoveBi = Optional.ofNullable(consumer);
        return this;
    }
}

