/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.cdi.container.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.enterprise.inject.spi.BeanManager;
import org.apache.aries.cdi.container.internal.CCR;
import org.apache.aries.cdi.container.internal.ChangeCount;
import org.apache.aries.cdi.container.internal.command.CDICommand;
import org.apache.aries.cdi.container.internal.container.CDIBundle;
import org.apache.aries.cdi.container.internal.container.ConfigurationListener;
import org.apache.aries.cdi.container.internal.container.ContainerBootstrap;
import org.apache.aries.cdi.container.internal.container.ContainerState;
import org.apache.aries.cdi.container.internal.container.ExtensionPhase;
import org.apache.aries.cdi.container.internal.model.ContainerActivator;
import org.apache.aries.cdi.container.internal.model.ContainerComponent;
import org.apache.aries.cdi.container.internal.model.FactoryActivator;
import org.apache.aries.cdi.container.internal.model.FactoryComponent;
import org.apache.aries.cdi.container.internal.model.SingleActivator;
import org.apache.aries.cdi.container.internal.model.SingleComponent;
import org.apache.aries.cdi.container.internal.spi.ContainerListener;
import org.apache.aries.cdi.container.internal.util.Logs;
import org.apache.aries.cdi.spi.CDIContainerInitializer;
import org.apache.felix.utils.extender.AbstractExtender;
import org.apache.felix.utils.extender.Extension;
import org.osgi.annotation.bundle.Header;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceObjects;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.cdi.runtime.CDIComponentRuntime;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.annotations.RequireConfigurationAdmin;
import org.osgi.service.log.Logger;
import org.osgi.service.log.LoggerFactory;
import org.osgi.util.promise.PromiseFactory;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Header(name="Bundle-Activator", value="${@class}")
@RequireConfigurationAdmin
public class Activator
extends AbstractExtender {
    private volatile CCR _ccr;
    private volatile ExecutorService _executorService;
    private volatile Logger _log;
    private volatile Logs _logs;
    private volatile PromiseFactory _promiseFactory;
    private volatile ServiceTracker<CDIContainerInitializer, ServiceObjects<CDIContainerInitializer>> _containerTracker;
    private volatile ServiceTracker<ContainerListener, ContainerListener> _containerListeners;
    private static final Map<Bundle, BeanManager> _cache = new ConcurrentHashMap<Bundle, BeanManager>();
    private BundleContext _bundleContext;
    private final ChangeCount _ccrChangeCount = new ChangeCount();
    private ServiceRegistration<CDIComponentRuntime> _ccrRegistration;
    private volatile CDICommand _command;
    private ServiceRegistration<?> _commandRegistration;

    public Activator() {
        this.setSynchronous(true);
    }

    @Override
    public void start(final BundleContext bundleContext) throws Exception {
        this._logs = new Logs.Builder(bundleContext).build();
        this._log = this._logs.getLogger(Activator.class);
        this._containerTracker = new ServiceTracker(bundleContext, CDIContainerInitializer.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<CDIContainerInitializer, ServiceObjects<CDIContainerInitializer>>(){

            public ServiceObjects<CDIContainerInitializer> addingService(ServiceReference<CDIContainerInitializer> reference) {
                return bundleContext.getServiceObjects(reference);
            }

            public void modifiedService(ServiceReference<CDIContainerInitializer> reference, ServiceObjects<CDIContainerInitializer> service) {
            }

            public void removedService(ServiceReference<CDIContainerInitializer> reference, ServiceObjects<CDIContainerInitializer> service) {
            }
        });
        this._containerTracker.open();
        this._containerListeners = new ServiceTracker(bundleContext, ContainerListener.class, null);
        this._containerListeners.open();
        this._executorService = Executors.newSingleThreadExecutor(worker -> {
            Thread t = new Thread(new ThreadGroup("Apache Aries CCR - CDI"), worker, "Aries CCR Thread (" + this.hashCode() + ")");
            t.setDaemon(false);
            return t;
        });
        this._promiseFactory = new PromiseFactory((Executor)this._executorService);
        this._ccr = new CCR(this._promiseFactory, this._logs);
        this._command = new CDICommand(this._ccr);
        if (this._log.isDebugEnabled()) {
            this._log.debug("CCR starting {}", (Object)bundleContext.getBundle());
        }
        this._bundleContext = bundleContext;
        this.registerCCR();
        this.registerCDICommand();
        super.start(bundleContext);
        if (this._log.isDebugEnabled()) {
            this._log.debug("CCR started {}", (Object)bundleContext.getBundle());
        }
    }

    private void registerCCR() {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("service.changecount", this._ccrChangeCount.get());
        ((Dictionary)properties).put("service.description", "Aries CDI - CDI Component Runtime");
        ((Dictionary)properties).put("service.vendor", "Apache Software Foundation");
        ChangeObserverFactory changeObserverFactory = new ChangeObserverFactory();
        this._ccrChangeCount.addObserver(changeObserverFactory);
        this._ccrRegistration = this._bundleContext.registerService(CDIComponentRuntime.class, (ServiceFactory)changeObserverFactory, properties);
    }

    private void registerCDICommand() {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("osgi.command.scope", "cdi");
        ((Dictionary)properties).put("osgi.command.function", new String[]{"list", "info"});
        ((Dictionary)properties).put("service.description", "Aries CDI - Gogo Commands");
        ((Dictionary)properties).put("service.vendor", "Apache Software Foundation");
        this._commandRegistration = this._bundleContext.registerService(Object.class, (Object)this._command, properties);
    }

    @Override
    public void stop(BundleContext bundleContext) throws Exception {
        if (this._log.isDebugEnabled()) {
            this._log.debug("CCR stoping {}", (Object)bundleContext.getBundle());
        }
        super.stop(bundleContext);
        this._commandRegistration.unregister();
        this._ccrRegistration.unregister();
        if (this._log.isDebugEnabled()) {
            this._log.debug("CCR stoped {}", (Object)bundleContext.getBundle());
        }
        this._executorService.shutdownNow();
        this._executorService.awaitTermination(2L, TimeUnit.SECONDS);
        this._containerTracker.close();
        this._containerListeners.close();
    }

    @Override
    protected Extension doCreateExtension(Bundle bundle) throws Exception {
        if (!this.requiresCDIExtender(bundle)) {
            return null;
        }
        ServiceTracker caTracker = new ServiceTracker(bundle.getBundleContext(), ConfigurationAdmin.class, null);
        caTracker.open();
        ServiceTracker loggerTracker = new ServiceTracker(bundle.getBundleContext(), LoggerFactory.class, null);
        loggerTracker.open();
        ContainerState containerState = new ContainerState(bundle, this._bundleContext.getBundle(), this._ccrChangeCount, this._promiseFactory, (ServiceTracker<ConfigurationAdmin, ConfigurationAdmin>)caTracker, this._logs);
        return new CDIBundle(this._ccr, containerState, new ExtensionPhase(containerState, new ConfigurationListener.Builder(containerState).component(new ContainerComponent.Builder(containerState, new ContainerActivator.Builder(containerState, new ContainerBootstrap(containerState, this._containerTracker, new ConfigurationListener.Builder(containerState), new SingleComponent.Builder(containerState, new SingleActivator.Builder(containerState)), new FactoryComponent.Builder(containerState, new FactoryActivator.Builder(containerState)), this._containerListeners))).build()).build()));
    }

    @Override
    protected void debug(Bundle bundle, String msg) {
        if (this._log.isTraceEnabled()) {
            this._log.trace(msg, (Object)bundle);
        }
    }

    @Override
    protected void warn(Bundle bundle, String msg, Throwable t) {
        if (this._log.isWarnEnabled()) {
            this._log.warn(msg, (Object)bundle, (Object)t);
        }
    }

    @Override
    protected void error(String msg, Throwable t) {
        if (this._log.isErrorEnabled()) {
            this._log.error(msg, (Object)t);
        }
    }

    private boolean requiresCDIExtender(Bundle bundle) {
        BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        List requiredBundleWires = bundleWiring.getRequiredWires("osgi.extender");
        for (BundleWire bundleWire : requiredBundleWires) {
            BundleRequirement requirement;
            Map requirementAttributes;
            List beans;
            Bundle providerWiringBundle;
            Map attributes = bundleWire.getCapability().getAttributes();
            if (!attributes.containsKey("osgi.extender") || !attributes.get("osgi.extender").equals("osgi.cdi") || !(providerWiringBundle = bundleWire.getProviderWiring().getBundle()).equals(this._bundleContext.getBundle()) || (beans = (List)(requirementAttributes = (requirement = bundleWire.getRequirement()).getAttributes()).get("beans")) == null || beans.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static void put(Bundle bundle, BeanManager beanManager) {
        _cache.put(bundle, beanManager);
    }

    public static BeanManager get(Bundle bundle) {
        return _cache.get(bundle);
    }

    public static void remove(Bundle bundle) {
        _cache.remove(bundle);
    }

    private class ChangeObserverFactory
    implements Observer,
    ServiceFactory<CDIComponentRuntime> {
        private final List<ServiceRegistration<CDIComponentRuntime>> _registrations = new CopyOnWriteArrayList<ServiceRegistration<CDIComponentRuntime>>();

        private ChangeObserverFactory() {
        }

        public CDIComponentRuntime getService(Bundle bundle, ServiceRegistration<CDIComponentRuntime> registration) {
            this._registrations.add(registration);
            return Activator.this._ccr;
        }

        public void ungetService(Bundle bundle, ServiceRegistration<CDIComponentRuntime> registration, CDIComponentRuntime service) {
            this._registrations.remove(registration);
        }

        @Override
        public void update(Observable o, Object arg) {
            if (!(o instanceof ChangeCount)) {
                return;
            }
            ChangeCount changeCount = (ChangeCount)o;
            for (ServiceRegistration<CDIComponentRuntime> registration : this._registrations) {
                Dictionary properties = registration.getReference().getProperties();
                properties.put("service.changecount", changeCount.get());
                registration.setProperties(properties);
            }
        }
    }
}

