/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.sdk.velocity;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;

public class FormatterResourceLoader
extends ClasspathResourceLoader {
    private static final Logger _log = Logger.getLogger(FormatterResourceLoader.class.getName());

    public InputStream getResourceStream(String name) throws ResourceNotFoundException {
        InputStream is = super.getResourceStream(name);
        try {
            String template = this.read(is);
            return new ByteArrayInputStream(template.getBytes("UTF-8"));
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Could not load template file", e);
            return is;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String read(InputStream is) throws IOException {
        StringBuilder sb = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.trim().equals("")) continue;
                if (line.trim().startsWith("##t")) {
                    line = line.trim().replaceAll("##t", "");
                    sb.append(line);
                    sb.append('\n');
                    continue;
                }
                if (line.trim().equals("##n")) {
                    sb.append('\n');
                    continue;
                }
                sb.append(line.replaceAll("\t", ""));
                sb.append('\n');
            }
        }
        finally {
            reader.close();
        }
        return sb.toString().trim();
    }
}

