/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.sdk.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.WordUtils;

public class LanguageUtil {
    public static final String BOOLEAN = "boolean";
    public static final String BYTE_ARRAY = "byte[]";
    public static final String DOUBLE = "double";
    public static final String FILE = "object<java.io.File>";
    public static final String INT = "int";
    public static final String LONG = "long";
    public static final String OBJECT_PREFIX = "object<";
    public static final String STRING = "string";
    public static final String VOID = "void";
    private static final Logger _log = Logger.getLogger(LanguageUtil.class.getName());
    private Properties _classNames = new Properties();

    public LanguageUtil() {
        InputStream is = this.getClass().getResourceAsStream("/class-names.properties");
        try {
            this._classNames.load(is);
        }
        catch (IOException ioe) {
            _log.log(Level.SEVERE, "Could not load class-names.properties", ioe);
        }
        InputStream ext = this.getClass().getResourceAsStream("/class-names-ext.properties");
        if (ext != null) {
            try {
                this._classNames.load(ext);
            }
            catch (IOException ioe) {
                _log.log(Level.SEVERE, "Could not load class-names-ext.properties", ioe);
            }
        }
    }

    public String capitalize(String word) {
        return WordUtils.capitalize((String)word);
    }

    public String getJSONWrapperClassName(String type) {
        if (type.startsWith(OBJECT_PREFIX)) {
            return type.substring(7, type.length() - 1);
        }
        return type;
    }

    public String getMethodName(String path) {
        String last = this.getMethodURL(path);
        String[] methodName = last.split("-");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < methodName.length; ++i) {
            String word = methodName[i];
            if (i > 0) {
                word = this.capitalize(word);
            }
            sb.append(word);
        }
        return sb.toString();
    }

    public String getMethodURL(String path) {
        int index = path.lastIndexOf("/") + 1;
        return path.substring(index);
    }

    public String getServiceClassName(String serviceContext) {
        StringBuilder sb = new StringBuilder();
        String className = this._classNames.getProperty(serviceContext);
        if (className == null) {
            className = WordUtils.capitalize((String)serviceContext);
        }
        sb.append(className);
        sb.append("Service");
        return sb.toString();
    }

    public String getType(String type) {
        if (type.equals("object<java.lang.Boolean>")) {
            return BOOLEAN;
        }
        if (type.equals("object<java.lang.Double>")) {
            return DOUBLE;
        }
        if (type.equals("object<java.lang.Integer>")) {
            return INT;
        }
        if (type.equals("object<java.lang.Long>")) {
            return LONG;
        }
        return type;
    }

    public boolean isArray(String type) {
        return type.endsWith("[]") || type.equals("object<list>") || type.equals("object<com.liferay.portal.kernel.json.JSONArray>") || type.startsWith("list");
    }
}

