/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.sdk.ios;

import com.liferay.mobile.sdk.BaseBuilder;
import com.liferay.mobile.sdk.http.Action;
import com.liferay.mobile.sdk.http.Discovery;
import com.liferay.mobile.sdk.ios.ObjectiveCUtil;
import com.liferay.mobile.sdk.util.Validator;
import com.liferay.mobile.sdk.velocity.VelocityUtil;
import java.io.File;
import java.util.List;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.tools.generic.EscapeTool;

public class iOSBuilder
extends BaseBuilder {
    protected static final String BOOL = "BOOL";
    protected static final String LR_UPLOAD_DATA = "LR_UPLOAD_DATA";

    @Override
    public void build(Discovery discovery, List<Action> actions, String packageName, int version, String filter, String destination) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (Validator.isNotNull(destination)) {
            sb.append(destination);
            sb.append("/ios/");
        }
        sb.append("Source/Service");
        destination = sb.toString();
        VelocityContext context = this.getVelocityContext(discovery, actions, version, filter);
        String headerTemplate = "templates/ios/h.vm";
        String headerPath = this.getFilePath(context, version, true, destination, filter);
        VelocityUtil.generate(context, headerTemplate, headerPath, true);
        String implTemplate = "templates/ios/m.vm";
        String implPath = this.getFilePath(context, version, false, destination, filter);
        VelocityUtil.generate(context, implTemplate, implPath, true);
    }

    protected String getFilePath(VelocityContext context, int version, boolean header, String destination, String filter) {
        String className = (String)context.get("className");
        StringBuilder sb = new StringBuilder();
        sb.append(destination);
        sb.append("/");
        sb.append("v");
        sb.append(version);
        sb.append("/");
        sb.append(filter);
        sb.append("/");
        File file = new File(sb.toString());
        file.mkdirs();
        sb.append(className);
        if (header) {
            sb.append(".h");
        } else {
            sb.append(".m");
        }
        return sb.toString();
    }

    protected VelocityContext getVelocityContext(Discovery discovery, List<Action> actions, int version, String filter) {
        VelocityContext context = new VelocityContext();
        ObjectiveCUtil objectiveCUtil = new ObjectiveCUtil();
        StringBuilder className = new StringBuilder("LR");
        className.append(objectiveCUtil.getServiceClassName(filter));
        className.append("_v");
        className.append(version);
        context.put("actions", actions);
        context.put(BOOL, (Object)BOOL);
        context.put("className", (Object)className.toString());
        context.put("discovery", (Object)discovery);
        context.put("esc", (Object)new EscapeTool());
        context.put("JSON_OBJECT_WRAPPER", (Object)"LRJSONObjectWrapper *");
        context.put("languageUtil", (Object)objectiveCUtil);
        context.put(LR_UPLOAD_DATA, (Object)"LRUploadData *");
        context.put("VOID", (Object)"void");
        return context;
    }
}

