/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.sdk.ios;

import com.liferay.mobile.sdk.util.LanguageUtil;

public class ObjectiveCUtil
extends LanguageUtil {
    public static final String BOOL = "BOOL";
    public static final String LONG_LONG = "long long";
    public static final String LR_JSON_OBJECT_WRAPPER = "LRJSONObjectWrapper *";
    public static final String LR_UPLOAD_DATA = "LRUploadData *";
    public static final String NS_ARRAY = "NSArray *";
    public static final String NS_DATA = "NSData *";
    public static final String NS_DICTIONARY = "NSDictionary *";
    public static final String NS_NUMBER = "NSNumber *";
    public static final String NS_STRING = "NSString *";

    public String getParamValue(String name, String type) {
        name = (type = this.getType(type)).equals(BOOL) || type.equals("double") || type.equals("int") || type.equals(LONG_LONG) ? "@(" + name + ")" : (type.equals(NS_DATA) ? "[self toString:" + name + "]" : "[self checkNull: " + name + "]");
        return name;
    }

    public String getReturnType(String type) {
        if ((type = this.getType(type)).equals("double") || type.equals("int") || type.equals(LONG_LONG)) {
            type = NS_NUMBER;
        }
        if (type.equals(LR_JSON_OBJECT_WRAPPER) || type.equals(LR_UPLOAD_DATA)) {
            return NS_DICTIONARY;
        }
        if (type.equals(NS_DATA)) {
            return NS_ARRAY;
        }
        return type;
    }

    @Override
    public String getType(String type) {
        if ((type = super.getType(type)).equals("double") || type.equals("int") || type.equals("void")) {
            return type;
        }
        if (type.equals("byte[]")) {
            return NS_DATA;
        }
        if (this.isArray(type)) {
            return NS_ARRAY;
        }
        if (type.equals("boolean")) {
            return BOOL;
        }
        if (type.equals("long")) {
            return LONG_LONG;
        }
        if (type.equals("string")) {
            return NS_STRING;
        }
        if (type.equals("object<java.io.File>")) {
            return LR_UPLOAD_DATA;
        }
        if (type.startsWith("object<")) {
            return LR_JSON_OBJECT_WRAPPER;
        }
        return NS_DICTIONARY;
    }
}

