/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.sdk.android;

import com.liferay.mobile.sdk.util.LanguageUtil;
import org.apache.commons.lang.WordUtils;

public class JavaUtil
extends LanguageUtil {
    public static final String INTEGER = "Integer";
    public static final String JSON_ARRAY = "JSONArray";
    public static final String JSON_OBJECT = "JSONObject";
    public static final String JSON_OBJECT_WRAPPER = "JSONObjectWrapper";
    public static final String UPLOAD_DATA = "UploadData";

    public String getReturnType(String type) {
        if ((type = this.getType(type)).equals("void")) {
            return type;
        }
        if (type.equals("int")) {
            return INTEGER;
        }
        if (type.equals(JSON_OBJECT_WRAPPER) || type.equals(UPLOAD_DATA)) {
            return JSON_OBJECT;
        }
        if (type.equals("byte[]")) {
            return JSON_ARRAY;
        }
        return WordUtils.capitalize((String)type);
    }

    @Override
    public String getType(String type) {
        if ((type = super.getType(type)).equals("boolean") || type.equals("byte[]") || type.equals("double") || type.equals("int") || type.equals("long") || type.equals("void")) {
            return type;
        }
        if (this.isArray(type)) {
            return JSON_ARRAY;
        }
        if (type.equals("string")) {
            return "String";
        }
        if (type.equals("object<java.io.File>")) {
            return UPLOAD_DATA;
        }
        if (type.startsWith("object<")) {
            return JSON_OBJECT_WRAPPER;
        }
        return JSON_OBJECT;
    }

    public boolean isPrimitive(String type) {
        return type.equals("boolean") || type.equals("double") || type.equals("int") || type.equals("long");
    }
}

