/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mobile.sdk.android;

import com.liferay.mobile.sdk.BaseBuilder;
import com.liferay.mobile.sdk.android.JavaUtil;
import com.liferay.mobile.sdk.http.Action;
import com.liferay.mobile.sdk.http.Discovery;
import com.liferay.mobile.sdk.util.Validator;
import com.liferay.mobile.sdk.velocity.VelocityUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.tools.generic.EscapeTool;

public class AndroidBuilder
extends BaseBuilder {
    protected static final String INTEGER = "INTEGER";
    protected static final String PACKAGE = "package";
    protected static final String UPLOAD_DATA = "UPLOAD_DATA";

    @Override
    public void build(Discovery discovery, List<Action> actions, String packageName, int version, String filter, String destination) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (Validator.isNotNull(destination)) {
            sb.append(destination);
            sb.append("/android/");
        }
        sb.append("src/gen/java");
        destination = sb.toString();
        VelocityContext context = this.getVelocityContext(discovery, actions, packageName, version, filter);
        String templatePath = "templates/android/service.vm";
        String filePath = this.getServiceFilePath(context, destination);
        VelocityUtil.generate(context, templatePath, filePath, true);
    }

    protected List<Action> excludeMethods(String className, List<Action> actions) {
        if (!className.equals("DDLRecordService")) {
            return actions;
        }
        actions = new ArrayList<Action>(actions);
        for (Action action : actions) {
            String path = action.getPath();
            if (!path.equals("/ddlrecord/add-record")) continue;
            actions.remove(action);
            break;
        }
        return actions;
    }

    protected String getServiceFilePath(VelocityContext context, String destination) {
        String packageName = (String)context.get(PACKAGE);
        String className = (String)context.get("className");
        String packagePath = packageName.replace(".", "/");
        StringBuilder sb = new StringBuilder();
        sb.append(destination);
        sb.append("/");
        sb.append(packagePath);
        sb.append("/");
        File file = new File(sb.toString());
        file.mkdirs();
        sb.append(className);
        sb.append(".java");
        return sb.toString();
    }

    protected VelocityContext getVelocityContext(Discovery discovery, List<Action> actions, String packageName, int version, String filter) {
        VelocityContext context = new VelocityContext();
        JavaUtil javaUtil = new JavaUtil();
        StringBuilder sb = new StringBuilder(packageName);
        sb.append(".v");
        sb.append(version);
        sb.append(".");
        sb.append(filter);
        packageName = sb.toString();
        String className = javaUtil.getServiceClassName(filter);
        context.put("BYTE_ARRAY", (Object)"byte[]");
        context.put("className", (Object)className);
        context.put("discovery", (Object)discovery);
        context.put("actions", this.excludeMethods(className, actions));
        context.put("esc", (Object)new EscapeTool());
        context.put(UPLOAD_DATA, (Object)"UploadData");
        context.put(INTEGER, (Object)"Integer");
        context.put("JSON_OBJECT_WRAPPER", (Object)"JSONObjectWrapper");
        context.put("languageUtil", (Object)javaUtil);
        context.put(PACKAGE, (Object)packageName);
        context.put("VOID", (Object)"void");
        return context;
    }
}

